/*
 * Decompiled with CFR 0.152.
 */
package top.fangwenmagician.calculationstring;

import java.util.LinkedList;
import top.fangwenmagician.calculationstring.CalculationString;
import top.fangwenmagician.calculationstring.ProcessControl;
import top.fangwenmagician.calculationstring.log.I_CalculationLog;
import top.fangwenmagician.calculationstring.operator.I_Operator;

class OperatorGroup {
    private final int priority;
    private final CalculationString calculationString;
    private final LinkedList<I_Operator> operatorList;

    OperatorGroup(CalculationString calculationString, int priority) {
        this.calculationString = calculationString;
        this.priority = priority;
        this.operatorList = new LinkedList();
    }

    <T extends I_Operator> void addOperator(T operator) {
        this.operatorList.add(operator);
    }

    <T extends I_CalculationLog> String calculation(String expression, T log) throws Exception {
        if (this.operatorList.size() > 1) {
            return this.calculationOperatorList(expression, log);
        }
        return this.calculationOperator(expression, log, this.operatorList.getFirst());
    }

    private <T extends I_CalculationLog> String calculationOperator(String expression, T log, I_Operator operator) throws Exception {
        if (operator.isExist(expression)) {
            expression = operator.calculation(expression, new ProcessControl(this.calculationString, log));
            return this.calculationOperator(expression, log, operator);
        }
        return expression;
    }

    private <T extends I_CalculationLog> String calculationOperatorList(String expression, T log) throws Exception {
        I_Operator maxOperator = this.getMaxOperator(expression);
        if (maxOperator == null) {
            return expression;
        }
        expression = maxOperator.calculation(expression, new ProcessControl(this.calculationString, log));
        return this.calculationOperatorList(expression, log);
    }

    private I_Operator getMaxOperator(String expression) throws Exception {
        I_Operator maxOperator = null;
        int maxPeerPriority = 0;
        for (I_Operator operator : this.operatorList) {
            if (!operator.isExist(expression)) continue;
            if (maxOperator == null) {
                maxOperator = operator;
                maxPeerPriority = operator.peerPriority(expression);
                continue;
            }
            int peerPriority = operator.peerPriority(expression);
            if (peerPriority <= maxPeerPriority) continue;
            maxOperator = operator;
            maxPeerPriority = peerPriority;
        }
        return maxOperator;
    }

    int getPriority() {
        return this.priority;
    }
}

