/*
 * Decompiled with CFR 0.152.
 */
package top.fangwenmagician.calculationstring;

import top.fangwenmagician.calculationstring.CalculationString;
import top.fangwenmagician.calculationstring.I_CalculationConfigure;
import top.fangwenmagician.calculationstring.I_CalculationString;
import top.fangwenmagician.calculationstring.log.F_LogProcessing;
import top.fangwenmagician.calculationstring.log.I_CalculationLog;

public class ProcessControl
implements I_CalculationString,
I_CalculationLog,
I_CalculationConfigure {
    private final CalculationString calculationString;
    private F_LogProcessing logProcessing;
    private I_CalculationLog log;

    public ProcessControl(CalculationString calculationString, I_CalculationLog log) {
        this.calculationString = calculationString;
        this.log = log;
    }

    @Override
    public String calculation(String expression) throws Exception {
        return this.calculationString.calculation(expression);
    }

    @Override
    public <T extends I_CalculationLog> String calculation(String expression, T log) throws Exception {
        return this.calculationString.calculation(expression, log);
    }

    @Override
    public void writeLog(String logText) throws Exception {
        if (this.log != null) {
            if (this.logProcessing == null) {
                this.log.writeLog(logText);
            } else {
                this.log.writeLog(this.logProcessing.processing(logText));
            }
        }
    }

    @Override
    public String removeLast() throws Exception {
        if (this.log != null) {
            return this.log.removeLast();
        }
        return null;
    }

    @Override
    public Object getConfigure() {
        return this.calculationString.getConfigure();
    }

    @Override
    public <T> T getConfigure(Class<T> tClass) {
        return this.calculationString.getConfigure(tClass);
    }

    public CalculationString getCalculationString() {
        return this.calculationString;
    }

    public I_CalculationLog getLog() {
        return this.log;
    }

    public <T extends I_CalculationLog> T getLog(Class<T> logClass) {
        return (T)((I_CalculationLog)logClass.cast(this.log));
    }

    public <T extends I_CalculationLog> void setLog(T log) {
        this.log = log;
    }

    public F_LogProcessing getLogProcessing() {
        return this.logProcessing;
    }

    public void setLogProcessing(F_LogProcessing logProcessing) {
        this.logProcessing = logProcessing;
    }
}

