/*
 * Decompiled with CFR 0.152.
 */
package top.fangwenmagician.calculationstring.operator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import top.fangwenmagician.calculationstring.ProcessControl;
import top.fangwenmagician.calculationstring.exception.CalculationException;
import top.fangwenmagician.calculationstring.operator.I_Operator;

public class Brackets
implements I_Operator {
    private final Pattern pattern = Pattern.compile("[\uff08(][^\uff09)]*[\uff09)]");

    @Override
    public int priority() {
        return 127;
    }

    @Override
    public boolean isExist(String expression) throws Exception {
        return this.pattern.matcher(expression).find();
    }

    @Override
    public int peerPriority(String expression) throws Exception {
        Matcher matcher = this.pattern.matcher(expression);
        if (matcher.find()) {
            return expression.length() - matcher.start();
        }
        return -1;
    }

    @Override
    public String calculation(String expression, ProcessControl processControl) throws Exception {
        Capture capture = this.getCapture(expression);
        String captureString = capture.getCaptureString();
        processControl.setLogProcessing(logText -> capture.getBeforeCaptureString() + logText + capture.getAfterCaptureString());
        String replaceString = processControl.calculation(captureString, processControl);
        expression = capture.replace(replaceString);
        processControl.setLogProcessing(null);
        processControl.removeLast();
        processControl.writeLog(expression);
        return expression;
    }

    private Capture getCapture(String expression) throws Exception {
        int weight = 0;
        Capture capture = new Capture(expression);
        char[] expressionCharArray = expression.toCharArray();
        for (int i = 0; i < expressionCharArray.length; ++i) {
            char c = expressionCharArray[i];
            if (c == '(' || c == '\uff08') {
                if (++weight != 1) continue;
                int beginIndex = i + 1;
                if (beginIndex < expressionCharArray.length) {
                    capture.setBeginIndex(beginIndex);
                    continue;
                }
                throw new CalculationException(expression + " \u6355\u83b7\u5931\u8d25");
            }
            if (c != ')' && c != '\uff09') continue;
            if (--weight == 0) {
                capture.setEndIndex(i);
                return capture;
            }
            if (weight >= 0) continue;
            throw new CalculationException(expression + " \u62ec\u53f7\u6355\u83b7\u5931\u8d25\uff1a\u53cd\u62ec\u53f7\u672a\u95ed\u5408");
        }
        throw new CalculationException(expression + " \u62ec\u53f7\u6355\u83b7\u5931\u8d25\uff1a\u6b63\u62ec\u53f7\u672a\u95ed\u5408");
    }

    protected class Capture {
        private final String expression;
        private int beginIndex;
        private int endIndex;

        public Capture(String expression) {
            this.expression = expression;
        }

        public String getCaptureString() throws Exception {
            String captureString = this.expression.substring(this.beginIndex, this.endIndex);
            if ("".equals(captureString)) {
                throw new CalculationException(this.expression + " \u6355\u83b7\u5931\u8d25\uff1a\u62ec\u53f7\u5185\u5b57\u7b26\u4e32\u4e3a\u7a7a");
            }
            return captureString;
        }

        public String getBeforeCaptureString() throws Exception {
            return this.expression.substring(0, this.beginIndex);
        }

        public String getAfterCaptureString() throws Exception {
            return this.expression.substring(this.endIndex);
        }

        public String replace(String replaceString) throws Exception {
            return this.expression.substring(0, this.beginIndex - 1) + replaceString + this.expression.substring(this.endIndex + 1);
        }

        public String getExpression() {
            return this.expression;
        }

        public int getBeginIndex() {
            return this.beginIndex;
        }

        public void setBeginIndex(int beginIndex) {
            this.beginIndex = beginIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public void setEndIndex(int endIndex) {
            this.endIndex = endIndex;
        }
    }
}

