/*
 * Decompiled with CFR 0.152.
 */
package top.fangwenmagician.calculationstring.operator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import top.fangwenmagician.calculationstring.ProcessControl;
import top.fangwenmagician.calculationstring.exception.CalculationException;
import top.fangwenmagician.calculationstring.operator.A_NormalRegularOperator;

public class Divide
extends A_NormalRegularOperator {
    private final int scale;
    private final RoundingMode roundingMode;

    public Divide() {
        this.scale = 2;
        this.roundingMode = RoundingMode.HALF_UP;
    }

    public Divide(int scale) {
        this.scale = scale;
        this.roundingMode = RoundingMode.HALF_UP;
    }

    public Divide(RoundingMode roundingMode) {
        this.scale = 2;
        this.roundingMode = roundingMode;
    }

    public Divide(int scale, RoundingMode roundingMode) {
        this.scale = scale;
        this.roundingMode = roundingMode;
    }

    @Override
    public String regularText() {
        return "([\\d.]+)\\/([\\d.]+)";
    }

    @Override
    public int priority() {
        return 100;
    }

    @Override
    public String calculation(String[] captureStrings, ProcessControl processControl) throws Exception {
        if (captureStrings.length >= 3) {
            String s1 = captureStrings[1];
            String s2 = captureStrings[2];
            try {
                Double.parseDouble(s1);
            }
            catch (Exception e) {
                throw new CalculationException("\"" + s1 + "\"\u65e0\u6cd5\u8f6c\u6362\u4e3adouble", e);
            }
            try {
                Double.parseDouble(s2);
            }
            catch (Exception e) {
                throw new CalculationException("\"" + s2 + "\"\u65e0\u6cd5\u8f6c\u6362\u4e3adouble", e);
            }
            return new BigDecimal(s1).divide(new BigDecimal(s2), this.scale, this.roundingMode).toString();
        }
        throw new CalculationException("\u672a\u6355\u83b7\u5230\u8db3\u591f\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u662f\u5426\u9519\u8bef");
    }
}

