/*
 * Decompiled with CFR 0.152.
 */
package top.fangwenmagician.calculationstring.operator;

import java.math.BigDecimal;
import top.fangwenmagician.calculationstring.ProcessControl;
import top.fangwenmagician.calculationstring.exception.CalculationException;
import top.fangwenmagician.calculationstring.operator.A_NormalRegularOperator;

public class Subtract
extends A_NormalRegularOperator {
    @Override
    public String regularText() {
        return "([\\d.]+)\\-([\\d.]+)";
    }

    @Override
    public int priority() {
        return 50;
    }

    @Override
    public String calculation(String[] captureStrings, ProcessControl processControl) throws Exception {
        if (captureStrings.length >= 3) {
            String s1 = captureStrings[1];
            String s2 = captureStrings[2];
            try {
                Double.parseDouble(s1);
            }
            catch (Exception e) {
                throw new CalculationException("\"" + s1 + "\"\u65e0\u6cd5\u8f6c\u6362\u4e3adouble", e);
            }
            try {
                Double.parseDouble(s2);
            }
            catch (Exception e) {
                throw new CalculationException("\"" + s2 + "\"\u65e0\u6cd5\u8f6c\u6362\u4e3adouble", e);
            }
            return new BigDecimal(s1).subtract(new BigDecimal(s2)).toString();
        }
        throw new CalculationException("\u672a\u6355\u83b7\u5230\u8db3\u591f\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u662f\u5426\u9519\u8bef");
    }
}

