/*
 * Decompiled with CFR 0.152.
 */
package com.focess.core.commands;

import com.focess.Main;
import com.focess.api.command.Command;
import com.focess.api.command.CommandResult;
import com.focess.api.command.CommandSender;
import com.focess.api.command.DataConverter;
import com.focess.api.command.converter.PluginDataConverter;
import com.focess.api.plugin.Plugin;
import com.focess.api.util.IOHandler;
import com.focess.core.plugin.PluginClassLoader;
import java.io.File;

public class ReloadCommand
extends Command {
    public ReloadCommand() {
        super("reload", new String[0]);
    }

    public static boolean reloadPlugin(Plugin plugin) {
        Main.getLogger().debugLang("start-reload-plugin", new Object[]{plugin.getName()});
        if (plugin == Main.getMainPlugin()) {
            return false;
        }
        File pluginFile = PluginClassLoader.disablePlugin((Plugin)plugin);
        try {
            PluginClassLoader classLoader = new PluginClassLoader(pluginFile);
            if (classLoader.load()) {
                return true;
            }
            classLoader.close();
            return false;
        }
        catch (Exception e) {
            Main.getLogger().thrLang("exception-reload-plugin", (Throwable)e, new Object[0]);
            return false;
        }
    }

    public void init() {
        this.setExecutorPermission(CommandSender::isConsole);
        this.addExecutor(1, (sender, data, ioHandler) -> {
            Plugin plugin = data.getPlugin();
            if (plugin == Main.getMainPlugin()) {
                ioHandler.outputLang("reload-command-reload-main-plugin", new Object[0]);
                return CommandResult.REFUSE;
            }
            if (!(plugin.getClass().getClassLoader() instanceof PluginClassLoader)) {
                ioHandler.outputLang("reload-command-plugin-loader-error", new Object[]{plugin.getName()});
                return CommandResult.REFUSE;
            }
            if (ReloadCommand.reloadPlugin(plugin)) {
                ioHandler.outputLang("reload-command-reload-plugin-succeed", new Object[]{plugin.getName()});
            } else {
                ioHandler.outputLang("reload-command-reload-plugin-failed", new Object[]{plugin.getName()});
            }
            return CommandResult.ALLOW;
        }, new String[0]).setDataConverters(new DataConverter[]{PluginDataConverter.PLUGIN_DATA_CONVERTER});
    }

    public void usage(CommandSender sender, IOHandler ioHandler) {
        ioHandler.output("Use: reload <plugin>");
    }
}

