/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.command.data;

import java.nio.BufferOverflowException;
import top.focess.qq.api.command.data.DataBuffer;

public class ObjectBuffer
extends DataBuffer<Object> {
    private final Object[] objects;
    private int pos;
    private int limit;

    private ObjectBuffer(int size) {
        this.objects = new Object[size];
        this.pos = 0;
        this.limit = size;
    }

    public static ObjectBuffer allocate(int size) {
        return new ObjectBuffer(size);
    }

    @Override
    public void flip() {
        this.limit = this.pos;
        this.pos = 0;
    }

    @Override
    public void put(Object o) {
        this.check();
        this.objects[this.pos++] = o;
    }

    private void check() {
        if (this.pos == this.limit) {
            throw new BufferOverflowException();
        }
    }

    @Override
    public Object get() {
        this.check2();
        return this.objects[this.pos++];
    }

    private void check2() {
        if (this.pos == this.limit) {
            throw new IndexOutOfBoundsException(this.pos + ":" + this.limit);
        }
    }
}

