/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.net;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import top.focess.qq.Main;
import top.focess.qq.api.net.PacketPreCodec;
import top.focess.qq.api.net.Receiver;
import top.focess.qq.api.net.Socket;
import top.focess.qq.api.net.packet.Packet;
import top.focess.qq.api.util.Pair;
import top.focess.qq.core.net.PacketHandler;

public class FocessSidedClientSocket
implements Socket {
    private final Map<Class<? extends Packet>, List<Pair<Receiver, Method>>> packetMethods = Maps.newHashMap();
    private final List<Receiver> receivers = Lists.newArrayList();
    private final String host;
    private final int port;

    public FocessSidedClientSocket(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public <T extends Packet> boolean sendPacket(T packet) {
        PacketPreCodec packetPreCodec = new PacketPreCodec();
        if (packetPreCodec.writePacket(packet)) {
            try {
                int length;
                java.net.Socket socket = new java.net.Socket(this.host, this.port);
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write(packetPreCodec.getBytes());
                outputStream.flush();
                socket.shutdownOutput();
                InputStream inputStream = socket.getInputStream();
                byte[] buffer = new byte[1024];
                PacketPreCodec codec = new PacketPreCodec();
                while ((length = inputStream.read(buffer)) != -1) {
                    codec.push(buffer, length);
                }
                Packet p = codec.readPacket();
                if (p != null) {
                    for (Pair<Receiver, Method> pair : this.packetMethods.getOrDefault(p.getClass(), Lists.newArrayList())) {
                        Method method = pair.getValue();
                        try {
                            method.setAccessible(true);
                            method.invoke((Object)pair.getKey(), p);
                        }
                        catch (Exception e) {
                            Main.getLogger().thrLang("exception-handle-packet", e, new Object[0]);
                        }
                    }
                }
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public void registerReceiver(Receiver receiver) {
        this.receivers.add(receiver);
        for (Method method : receiver.getClass().getDeclaredMethods()) {
            Class<?> packetClass;
            PacketHandler handler = method.getAnnotation(PacketHandler.class);
            if (handler == null || method.getParameterTypes().length != 1 || !Packet.class.isAssignableFrom(packetClass = method.getParameterTypes()[0]) || Modifier.isAbstract(packetClass.getModifiers())) continue;
            try {
                this.packetMethods.compute(packetClass, (k, v) -> {
                    if (v == null) {
                        v = Lists.newArrayList();
                    }
                    v.add(Pair.of(receiver, method));
                    return v;
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean containsServerSide() {
        return false;
    }

    @Override
    public boolean containsClientSide() {
        return true;
    }

    @Override
    public void close() {
        for (Receiver receiver : this.receivers) {
            receiver.close();
        }
    }
}

