/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.net;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.ServerSocket;
import java.util.List;
import java.util.Map;
import top.focess.qq.Main;
import top.focess.qq.api.exceptions.IllegalPortException;
import top.focess.qq.api.net.ClientReceiver;
import top.focess.qq.api.net.PacketPreCodec;
import top.focess.qq.api.net.Receiver;
import top.focess.qq.api.net.ServerReceiver;
import top.focess.qq.api.net.Socket;
import top.focess.qq.api.net.packet.Packet;
import top.focess.qq.api.util.Pair;
import top.focess.qq.core.net.PacketHandler;

public class FocessSocket
implements Socket {
    private final Map<Class<? extends Packet>, List<Pair<Receiver, Method>>> packetMethods = Maps.newHashMap();
    private final List<Receiver> receivers = Lists.newArrayList();
    private final Thread thread;
    private final ServerSocket server;
    private final int localPort;
    private boolean serverSide = false;
    private boolean clientSide = false;

    public FocessSocket(int localPort) throws IllegalPortException {
        this.localPort = localPort;
        try {
            this.server = new ServerSocket(localPort);
        }
        catch (IOException e) {
            throw new IllegalPortException(localPort);
        }
        this.thread = new Thread(() -> this.lambda$new$0(localPort));
        this.thread.start();
    }

    @Override
    public void registerReceiver(Receiver receiver) {
        this.receivers.add(receiver);
        if (receiver instanceof ServerReceiver) {
            this.serverSide = true;
        }
        if (receiver instanceof ClientReceiver) {
            this.clientSide = true;
        }
        for (Method method : receiver.getClass().getDeclaredMethods()) {
            Class<?> packetClass;
            PacketHandler handler = method.getAnnotation(PacketHandler.class);
            if (handler == null || method.getParameterTypes().length != 1 || !Packet.class.isAssignableFrom(packetClass = method.getParameterTypes()[0]) || Modifier.isAbstract(packetClass.getModifiers())) continue;
            try {
                this.packetMethods.compute(packetClass, (k, v) -> {
                    if (v == null) {
                        v = Lists.newArrayList();
                    }
                    v.add(Pair.of(receiver, method));
                    return v;
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean containsServerSide() {
        return this.serverSide;
    }

    @Override
    public boolean containsClientSide() {
        return this.clientSide;
    }

    public <T extends Packet> boolean sendPacket(String targetHost, int targetPort, T packet) {
        PacketPreCodec packetPreCodec = new PacketPreCodec();
        if (packetPreCodec.writePacket(packet)) {
            try {
                java.net.Socket socket = new java.net.Socket(targetHost, targetPort);
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write(packetPreCodec.getBytes());
                outputStream.flush();
                outputStream.close();
                return true;
            }
            catch (IOException e) {
                Main.getLogger().thrLang("exception-send-packet", e, new Object[0]);
                return false;
            }
        }
        return false;
    }

    @Override
    public void close() {
        try {
            this.server.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.thread.stop();
        for (Receiver receiver : this.receivers) {
            receiver.close();
        }
    }

    public int getLocalPort() {
        return this.localPort;
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$new$0(int localPort) {
        Main.getLogger().debugLang("start-focess-socket", new Object[]{localPort});
        while (true) {
            try {
                block5: while (true) {
                    socket = this.server.accept();
                    inputStream = socket.getInputStream();
                    buffer = new byte[1024];
                    packetPreCodec = new PacketPreCodec();
                    while ((length = inputStream.read(buffer)) != -1) {
                        packetPreCodec.push(buffer, length);
                    }
                    inputStream.close();
                    packet = packetPreCodec.readPacket();
                    if (packet == null) continue;
                    var8_9 = this.packetMethods.getOrDefault(packet.getClass(), Lists.newArrayList()).iterator();
                    while (true) {
                        if (var8_9.hasNext()) ** break;
                        continue block5;
                        pair = var8_9.next();
                        method = pair.getValue();
                        try {
                            method.setAccessible(true);
                            method.invoke((Object)pair.getKey(), new Object[]{packet});
                        }
                        catch (Exception e) {
                            Main.getLogger().thrLang("exception-handle-packet", e, new Object[0]);
                        }
                    }
                    break;
                }
            }
            catch (IOException e) {
                Main.getLogger().thrLang("exception-focess-socket", e, new Object[0]);
                if (!this.server.isClosed()) continue;
                return;
            }
            break;
        }
    }
}

