/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.net;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.List;
import java.util.Map;
import top.focess.qq.Main;
import top.focess.qq.api.exceptions.IllegalPortException;
import top.focess.qq.api.net.PacketPreCodec;
import top.focess.qq.api.net.Receiver;
import top.focess.qq.api.net.Socket;
import top.focess.qq.api.net.packet.ConnectPacket;
import top.focess.qq.api.net.packet.Packet;
import top.focess.qq.api.net.packet.SidedConnectPacket;
import top.focess.qq.api.util.Pair;
import top.focess.qq.core.net.PacketHandler;

public class FocessUDPSocket
implements Socket {
    private final Map<Class<? extends Packet>, List<Pair<Receiver, Method>>> packetMethods = Maps.newHashMap();
    private final List<Receiver> receivers = Lists.newArrayList();
    private final DatagramSocket socket;
    private final DatagramPacket packet;
    private final Thread thread;

    public FocessUDPSocket(int port) throws IllegalPortException {
        try {
            this.socket = new DatagramSocket(port);
        }
        catch (SocketException e) {
            throw new IllegalPortException(port);
        }
        this.packet = new DatagramPacket(new byte[0x100000], 0x100000);
        this.thread = new Thread(() -> this.lambda$new$0(port));
        this.thread.start();
    }

    @Override
    public void registerReceiver(Receiver receiver) {
        this.receivers.add(receiver);
        for (Method method : receiver.getClass().getDeclaredMethods()) {
            Class<?> packetClass;
            PacketHandler handler = method.getAnnotation(PacketHandler.class);
            if (handler == null || method.getParameterTypes().length != 1 || !method.getReturnType().equals(Void.TYPE) && !Packet.class.isAssignableFrom(method.getReturnType()) || !Packet.class.isAssignableFrom(packetClass = method.getParameterTypes()[0]) || Modifier.isAbstract(packetClass.getModifiers())) continue;
            try {
                this.packetMethods.compute(packetClass, (k, v) -> {
                    if (v == null) {
                        v = Lists.newArrayList();
                    }
                    v.add(Pair.of(receiver, method));
                    return v;
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean containsServerSide() {
        return true;
    }

    @Override
    public boolean containsClientSide() {
        return false;
    }

    @Override
    public void close() {
        this.socket.close();
        this.thread.stop();
        for (Receiver receiver : this.receivers) {
            receiver.close();
        }
    }

    public void sendPacket(String host, int port, Packet packet) {
        PacketPreCodec handler = new PacketPreCodec();
        handler.writePacket(packet);
        DatagramPacket sendPacket = new DatagramPacket(handler.getBytes(), handler.getBytes().length, new InetSocketAddress(host, port));
        try {
            this.socket.send(sendPacket);
        }
        catch (IOException e) {
            Main.getLogger().thrLang("exception-send-packet", e, new Object[0]);
        }
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$new$0(int port) {
        Main.getLogger().debugLang("start-focess-udp-socket", new Object[]{port});
        while (true) {
            try {
                block5: while (true) {
                    this.socket.receive(this.packet);
                    packetPreCodec = new PacketPreCodec();
                    packetPreCodec.push(this.packet.getData(), this.packet.getOffset(), this.packet.getLength());
                    packet = packetPreCodec.readPacket();
                    if (packet == null) continue;
                    if (packet instanceof SidedConnectPacket) {
                        name = ((SidedConnectPacket)packet).getName();
                        packet = new ConnectPacket(this.packet.getAddress().getHostName(), this.packet.getPort(), name);
                    }
                    var4_5 = this.packetMethods.getOrDefault(packet.getClass(), Lists.newArrayList()).iterator();
                    while (true) {
                        if (var4_5.hasNext()) ** break;
                        continue block5;
                        pair = var4_5.next();
                        method = pair.getValue();
                        try {
                            method.setAccessible(true);
                            o = method.invoke((Object)pair.getKey(), new Object[]{packet});
                            if (o == null) continue;
                            handler = new PacketPreCodec();
                            handler.writePacket((Packet)o);
                            sendPacket = new DatagramPacket(handler.getBytes(), handler.getBytes().length, this.packet.getSocketAddress());
                            this.socket.send(sendPacket);
                        }
                        catch (Exception e) {
                            Main.getLogger().thrLang("exception-handle-packet", e, new Object[0]);
                        }
                    }
                    break;
                }
            }
            catch (IOException e) {
                Main.getLogger().thrLang("exception-focess-udp-socket", e, new Object[0]);
                continue;
            }
            break;
        }
    }
}

