/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import top.focess.qq.Main;
import top.focess.qq.api.command.Command;
import top.focess.qq.api.command.DataConverter;
import top.focess.qq.api.command.data.DataBuffer;
import top.focess.qq.api.plugin.Plugin;

public class DataCollection {
    private static final Map<Plugin, List<DataConverter<?>>> PLUGIN_DATA_CONVERTER_MAP = Maps.newConcurrentMap();
    private static final Map<DataConverter<?>, BufferGetter> DATA_CONVERTER_BUFFER_MAP = Maps.newConcurrentMap();
    private final Map<Class<?>, DataBuffer> buffers = Maps.newHashMap();

    public DataCollection(DataConverter<?>[] dataConverters) {
        HashMap map = Maps.newHashMap();
        for (DataConverter<?> dataConverter : dataConverters) {
            map.compute(dataConverter, (k, v) -> {
                if (v == null) {
                    v = 0;
                }
                Integer n = v;
                Integer n2 = v = Integer.valueOf(v + 1);
                return v;
            });
        }
        for (DataConverter dataConverter : map.keySet()) {
            this.buffers.put(dataConverter.getTargetClass(), DATA_CONVERTER_BUFFER_MAP.get(dataConverter).newBuffer((Integer)map.get(dataConverter)));
        }
    }

    public static void register(Plugin plugin, DataConverter<?> dataConverter, BufferGetter bufferGetter) {
        PLUGIN_DATA_CONVERTER_MAP.compute(plugin, (k, v) -> {
            if (v == null) {
                v = Lists.newArrayList();
            }
            v.add(dataConverter);
            return v;
        });
        DATA_CONVERTER_BUFFER_MAP.put(dataConverter, bufferGetter);
    }

    public static void unregister(Plugin plugin) {
        for (DataConverter dataConverter : (List)PLUGIN_DATA_CONVERTER_MAP.getOrDefault(plugin, Lists.newArrayList())) {
            DATA_CONVERTER_BUFFER_MAP.remove(dataConverter);
        }
        PLUGIN_DATA_CONVERTER_MAP.remove(plugin);
    }

    public static boolean unregisterAll() {
        boolean ret = false;
        for (Plugin plugin : PLUGIN_DATA_CONVERTER_MAP.keySet()) {
            if (plugin != Main.getMainPlugin()) {
                ret = true;
            }
            DataCollection.unregister(plugin);
        }
        PLUGIN_DATA_CONVERTER_MAP.clear();
        return ret;
    }

    void flip() {
        for (Class<?> c : this.buffers.keySet()) {
            this.buffers.get(c).flip();
        }
    }

    void write(String s) {
        this.write(String.class, s);
    }

    void writeInt(int i) {
        this.write(Integer.class, i);
    }

    void writeDouble(double d) {
        this.write(Double.class, d);
    }

    void writeBoolean(boolean b) {
        this.write(Boolean.class, b);
    }

    void writeLong(long l) {
        this.write(Long.class, l);
    }

    public String get() {
        return this.get(String.class);
    }

    public int getInt() {
        return this.get(Integer.class);
    }

    public double getDouble() {
        return this.get(Double.class);
    }

    public boolean getBoolean() {
        return this.get(Boolean.class);
    }

    public long getLong() {
        return this.get(Long.class);
    }

    public void writePlugin(Plugin p) {
        this.write(Plugin.class, p);
    }

    public Plugin getPlugin() {
        return this.get(Plugin.class);
    }

    public Command getCommand() {
        return this.get(Command.class);
    }

    public void writeCommand(Command command) {
        this.write(Command.class, command);
    }

    public <T> void write(Class<T> cls, T t) {
        this.buffers.compute(cls, (Key2, value) -> {
            if (value == null) {
                throw new UnsupportedOperationException();
            }
            value.put(t);
            return value;
        });
    }

    public <T> T get(Class<T> c) {
        if (this.buffers.get(c) == null) {
            throw new UnsupportedOperationException();
        }
        return this.buffers.get(c).get();
    }

    @FunctionalInterface
    public static interface BufferGetter {
        public DataBuffer<?> newBuffer(int var1);
    }
}

