/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.focess.qq.Main;
import top.focess.qq.api.command.Command;
import top.focess.qq.api.command.DataCollection;
import top.focess.qq.api.command.DataConverter;
import top.focess.qq.api.event.Event;
import top.focess.qq.api.event.EventHandler;
import top.focess.qq.api.event.Listener;
import top.focess.qq.api.event.ListenerHandler;
import top.focess.qq.api.exceptions.PluginDuplicateException;
import top.focess.qq.api.exceptions.PluginLoaderException;
import top.focess.qq.api.plugin.PluginDescription;
import top.focess.qq.api.util.config.DefaultConfig;
import top.focess.qq.api.util.config.LangConfig;
import top.focess.qq.api.util.version.Version;
import top.focess.qq.api.util.yaml.YamlConfiguration;
import top.focess.qq.core.plugin.PluginClassLoader;
import top.focess.qq.core.plugin.PluginCoreClassLoader;
import top.focess.qq.core.util.MethodCaller;

public abstract class Plugin {
    private static final String path = Plugin.class.getProtectionDomain().getCodeSource().getLocation().getFile();
    private String author;
    private Version version;
    private String name;
    @Deprecated
    private YamlConfiguration configuration;
    @Deprecated
    private File config;
    private LangConfig langConfig;
    private DefaultConfig defaultConfig;
    private PluginDescription pluginDescription;
    private boolean isEnabled;

    public Plugin(String name, String author, Version version) {
        this.name = name;
        this.author = author;
        this.version = version;
        this.init();
    }

    protected Plugin() {
    }

    private void init() {
        if (!(this.getClass().getClassLoader() instanceof PluginClassLoader) && this.getClass() != Main.MainPlugin.class) {
            throw new PluginLoaderException(this.name);
        }
        if (Plugin.getPlugin(this.getClass()) != null) {
            throw new PluginDuplicateException(this.name, "Cannot new a plugin at runtime");
        }
        this.pluginDescription = this.getClass() != Main.MainPlugin.class ? new PluginDescription(YamlConfiguration.load(this.loadResource("plugin.yml"))) : new PluginDescription();
        if (!this.getClass().getName().equals(this.pluginDescription.getMain()) && this.getClass() != Main.MainPlugin.class) {
            throw new IllegalStateException("Cannot new a plugin at runtime");
        }
        if (!this.getDefaultFolder().exists() && !this.getDefaultFolder().mkdirs()) {
            Main.getLogger().debugLang("create-default-folder-failed", this.getDefaultFolder().getAbsolutePath());
        }
        this.config = new File(this.getDefaultFolder(), "config.yml");
        if (!this.config.exists()) {
            try {
                InputStream configResource = this.loadResource("config.yml");
                if (configResource != null) {
                    Files.copy(configResource, this.config.toPath(), new CopyOption[0]);
                    configResource.close();
                } else if (!this.config.createNewFile()) {
                    Main.getLogger().debugLang("create-config-file-failed", this.config.getAbsolutePath());
                }
            }
            catch (IOException e) {
                Main.getLogger().thrLang("exception-create-config-file", e, new Object[0]);
            }
        }
        this.configuration = YamlConfiguration.loadFile(this.config);
        this.defaultConfig = new DefaultConfig(this.config);
        this.langConfig = new LangConfig(this.loadResource("lang.yml"));
    }

    public static Plugin getPlugin(Class<? extends Plugin> plugin) {
        return PluginClassLoader.getPlugin(plugin);
    }

    public static Plugin getPlugin(String name) {
        return PluginClassLoader.getPlugin(name);
    }

    @Nullable
    public static Plugin thisPlugin() {
        return PluginCoreClassLoader.getClassLoadedBy(MethodCaller.getCallerClass());
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public abstract void enable();

    public abstract void disable();

    public final void onEnable() {
        this.isEnabled = true;
        this.enable();
    }

    public final void onDisable() {
        this.disable();
        this.isEnabled = false;
    }

    @NotNull
    public File getDefaultFolder() {
        return new File(new File(new File(path).getParent(), "plugins"), this.getName());
    }

    @NotNull
    public File getConfigFile() {
        return this.config;
    }

    @NotNull
    public YamlConfiguration getConfig() {
        return this.configuration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plugin plugin = (Plugin)o;
        return Objects.equals(this.name, plugin.name);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public void registerListener(Listener listener) {
        ListenerHandler.register(this, listener);
        for (Method method : listener.getClass().getDeclaredMethods()) {
            Class<?> eventClass;
            EventHandler handler = method.getAnnotation(EventHandler.class);
            if (handler == null || method.getParameterTypes().length != 1 || !Event.class.isAssignableFrom(eventClass = method.getParameterTypes()[0]) || Modifier.isAbstract(eventClass.getModifiers())) continue;
            try {
                Field field = eventClass.getDeclaredField("LISTENER_HANDLER");
                boolean flag = field.isAccessible();
                field.setAccessible(true);
                ListenerHandler listenerHandler = (ListenerHandler)field.get(null);
                field.setAccessible(flag);
                listenerHandler.register(listener, method, handler);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void registerCommand(Command command) {
        Command.register(this, command);
    }

    public void registerBuffer(DataConverter<?> dataConverter, DataCollection.BufferGetter bufferGetter) {
        DataCollection.register(this, dataConverter, bufferGetter);
    }

    public String getAuthor() {
        return this.author;
    }

    public Version getVersion() {
        return this.version;
    }

    public LangConfig getLangConfig() {
        return this.langConfig;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public PluginDescription getPluginDescription() {
        return this.pluginDescription;
    }

    public InputStream loadResource(String path) {
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }
}

