/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.util.network;

import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.focess.qq.api.util.json.JSON;

public class HttpResponse {
    public static final int UNKNOWN_REQUEST = -1;
    public static final int EXCEPTION = -2;
    private static final HttpResponse UNKNOWN_REQUEST_TYPE = new HttpResponse();
    private final int code;
    private Headers headers;
    private String value;
    private Exception exception;

    private HttpResponse() {
        this.code = -1;
    }

    public boolean isError() {
        return this.code == -2;
    }

    public HttpResponse(Exception e) {
        this.code = -2;
        this.exception = e;
    }

    public HttpResponse(int code, Headers headers, String value) {
        this.code = code;
        this.value = value;
        this.headers = headers;
    }

    public static HttpResponse ofNull() {
        return UNKNOWN_REQUEST_TYPE;
    }

    @Nullable
    public Exception getException() {
        return this.exception;
    }

    public int getCode() {
        return this.code;
    }

    @NotNull
    public JSON getAsJSON() {
        return new JSON(this.value);
    }

    @Nullable
    public String getResponse() {
        return this.value;
    }

    @Nullable
    public Headers getHeaders() {
        return this.headers;
    }
}

