/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.util.yaml;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;
import top.focess.qq.Main;
import top.focess.qq.api.exceptions.YamlLoadException;
import top.focess.qq.api.util.Base64;
import top.focess.qq.api.util.SectionMap;
import top.focess.qq.api.util.yaml.YamlConfigurationSection;
import top.focess.qq.core.plugin.ObjectInputCoreStream;

public class YamlConfiguration
implements SectionMap {
    private static final Yaml YAML = new Yaml();
    private final Map<String, Object> values;

    public YamlConfiguration(@Nullable Map<String, Object> values) {
        this.values = values == null ? Maps.newHashMap() : values;
    }

    public static YamlConfiguration loadFile(File file) {
        try {
            FileReader reader = new FileReader(file);
            YamlConfiguration yamlConfiguration = new YamlConfiguration((Map)YAML.load((Reader)reader));
            reader.close();
            return yamlConfiguration;
        }
        catch (IOException e) {
            Main.getLogger().thrLang("exception-load-file", e, new Object[0]);
            return null;
        }
    }

    public static YamlConfiguration load(InputStream inputStream) {
        return new YamlConfiguration((Map)YAML.load(inputStream));
    }

    @Override
    public YamlConfigurationSection createSection(String key) {
        HashMap values = Maps.newHashMap();
        this.values.put(key, values);
        return new YamlConfigurationSection(this, values);
    }

    @Override
    public void set(String key, Object value) {
        if (value == null) {
            this.values.put(key, "null");
        } else if (value.getClass().isPrimitive() || value.getClass().equals(Double.class) || value.getClass().equals(Float.class) || value.getClass().equals(Short.class) || value.getClass().equals(Character.class) || value.getClass().equals(Long.class) || value.getClass().equals(Integer.class) || value.getClass().equals(Boolean.class) || value.getClass().equals(Byte.class) || value.getClass().equals(String.class)) {
            this.values.put(key, value);
        } else {
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                ObjectOutputStream outputStream = new ObjectOutputStream(stream);
                outputStream.writeObject(value);
                outputStream.close();
                this.values.put(key, "!!" + Base64.base64Encode(stream.toByteArray()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public <T> T get(String key) {
        Object value = SectionMap.super.get(key);
        if (value == null) {
            return null;
        }
        if (value.getClass().isPrimitive() || value.getClass().equals(Double.class) || value.getClass().equals(Float.class) || value.getClass().equals(Short.class) || value.getClass().equals(Character.class) || value.getClass().equals(Long.class) || value.getClass().equals(Integer.class) || value.getClass().equals(Boolean.class) || value.getClass().equals(Byte.class)) {
            return value;
        }
        String str = (String)value;
        if (str.equals("null")) {
            return null;
        }
        if (str.startsWith("!!")) {
            try {
                ObjectInputCoreStream inputStream = new ObjectInputCoreStream(new ByteArrayInputStream(Base64.base64Decode(str.substring(2))));
                Object t = inputStream.readObject();
                inputStream.close();
                return (T)t;
            }
            catch (Exception e) {
                throw new YamlLoadException(e);
            }
        }
        return value;
    }

    @Override
    public Map<String, Object> getValues() {
        return this.values;
    }

    public void save(File file) {
        try {
            YAML.dump(this.values, (Writer)new FileWriter(file));
        }
        catch (IOException e) {
            Main.getLogger().thrLang("exception-save-file", e, new Object[0]);
        }
    }

    @Override
    public YamlConfigurationSection getSection(String key) {
        if (this.get(key) instanceof Map) {
            return new YamlConfigurationSection(this, (Map)this.get(key));
        }
        throw new IllegalStateException("This " + key + " is not a valid section.");
    }

    public String toString() {
        return this.values.toString();
    }
}

