/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.schedule;

import com.google.common.collect.Queues;
import java.time.Duration;
import java.util.Queue;
import java.util.concurrent.Callable;
import top.focess.qq.Main;
import top.focess.qq.api.exceptions.SchedulerClosedException;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.api.schedule.Callback;
import top.focess.qq.api.schedule.Scheduler;
import top.focess.qq.api.schedule.Task;
import top.focess.qq.core.schedule.ComparableTask;
import top.focess.qq.core.schedule.FocessCallback;
import top.focess.qq.core.schedule.FocessTask;
import top.focess.qq.core.schedule.ThreadPoolSchedulerThread;

public class ThreadPoolScheduler
implements Scheduler {
    private final Plugin plugin;
    private final Queue<ComparableTask> tasks = Queues.newPriorityBlockingQueue();
    private final ThreadPoolSchedulerThread[] threads;
    private boolean shouldStop = false;
    private int currentThread = 0;

    public ThreadPoolScheduler(Plugin plugin, int poolSize) {
        this.plugin = plugin;
        this.threads = new ThreadPoolSchedulerThread[poolSize];
        for (int i = 0; i < poolSize; ++i) {
            this.threads[i] = new ThreadPoolSchedulerThread(this.getName() + "-" + i);
            this.threads[i].start();
        }
        new SchedulerThread(this.getName()).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task run(Runnable runnable, Duration delay) {
        Queue<ComparableTask> queue = this.tasks;
        synchronized (queue) {
            if (this.shouldStop) {
                throw new SchedulerClosedException(this);
            }
            FocessTask task = new FocessTask(runnable, this);
            this.tasks.add(new ComparableTask(System.currentTimeMillis() + delay.toMillis(), task));
            this.tasks.notify();
            return task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task runTimer(Runnable runnable, Duration delay, Duration period) {
        Queue<ComparableTask> queue = this.tasks;
        synchronized (queue) {
            if (this.shouldStop) {
                throw new SchedulerClosedException(this);
            }
            FocessTask task = new FocessTask(runnable, period, this);
            this.tasks.add(new ComparableTask(System.currentTimeMillis() + delay.toMillis(), task));
            this.tasks.notify();
            return task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> Callback<V> submit(Callable<V> callable, Duration delay) {
        Queue<ComparableTask> queue = this.tasks;
        synchronized (queue) {
            if (this.shouldStop) {
                throw new SchedulerClosedException(this);
            }
            FocessCallback<V> callback = new FocessCallback<V>(callable, this);
            this.tasks.add(new ComparableTask(System.currentTimeMillis() + delay.toMillis(), callback));
            this.tasks.notify();
            return callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAll() {
        Queue<ComparableTask> queue = this.tasks;
        synchronized (queue) {
            this.tasks.clear();
        }
    }

    @Override
    public String getName() {
        return this.getPlugin().getName() + "-ThreadPoolScheduler";
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void close() {
        this.shouldStop = true;
        this.cancelAll();
        for (ThreadPoolSchedulerThread thread : this.threads) {
            thread.close();
        }
    }

    private class SchedulerThread
    extends Thread {
        public SchedulerThread(String name) {
            super(name);
        }

        private ThreadPoolSchedulerThread getAvailableThread() {
            for (int i = 1; i <= ThreadPoolScheduler.this.threads.length; ++i) {
                int next = (ThreadPoolScheduler.this.currentThread + i) % ThreadPoolScheduler.this.threads.length;
                if (!ThreadPoolScheduler.this.threads[next].isAvailable()) continue;
                ThreadPoolScheduler.this.currentThread = next;
                return ThreadPoolScheduler.this.threads[next];
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Queue queue = ThreadPoolScheduler.this.tasks;
                        synchronized (queue) {
                            ComparableTask task;
                            if (ThreadPoolScheduler.this.shouldStop) {
                                return;
                            }
                            if (ThreadPoolScheduler.this.tasks.isEmpty()) {
                                ThreadPoolScheduler.this.tasks.wait();
                            }
                            if ((task = (ComparableTask)ThreadPoolScheduler.this.tasks.peek()) != null) {
                                ComparableTask comparableTask = task;
                                synchronized (comparableTask) {
                                    if (task.isCancelled()) {
                                        ThreadPoolScheduler.this.tasks.poll();
                                        continue;
                                    }
                                    if (task.getTime() <= System.currentTimeMillis()) {
                                        ThreadPoolSchedulerThread thread = this.getAvailableThread();
                                        if (thread == null) {
                                            continue;
                                        }
                                        ThreadPoolScheduler.this.tasks.poll();
                                        thread.startTask(task.getTask());
                                        if (task.getTask().isPeriod()) {
                                            ThreadPoolScheduler.this.tasks.add(new ComparableTask(System.currentTimeMillis() + task.getTask().getPeriod().toMillis(), task.getTask()));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Main.getLogger().thrLang("exception-thread-pool-scheduler", e, new Object[0]);
                    continue;
                }
                break;
            }
        }
    }
}

