/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.listener;

import com.google.common.collect.Lists;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.event.EventHandler;
import top.focess.qq.api.event.EventManager;
import top.focess.qq.api.event.EventPriority;
import top.focess.qq.api.event.Listener;
import top.focess.qq.api.event.chat.ConsoleChatEvent;
import top.focess.qq.api.event.message.ConsoleMessageEvent;
import top.focess.qq.api.exceptions.InputTimeoutException;
import top.focess.qq.api.schedule.Scheduler;
import top.focess.qq.api.schedule.Schedulers;
import top.focess.qq.api.util.IOHandler;
import top.focess.qq.api.util.Pair;

public class ConsoleListener
implements Listener {
    private static final Scheduler EXECUTOR = Schedulers.newThreadPoolScheduler(FocessQQ.getMainPlugin(), 10);
    public static final Queue<Pair<IOHandler, Long>> QUESTS = Lists.newLinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onConsoleChat(ConsoleChatEvent event) {
        Queue<Pair<IOHandler, Long>> queue = QUESTS;
        synchronized (queue) {
            if (!QUESTS.isEmpty()) {
                Pair<IOHandler, Long> element = QUESTS.poll();
                while (element != null && System.currentTimeMillis() - element.getValue() > 600000L) {
                    element.getKey().input(null);
                    element = QUESTS.poll();
                }
                if (element == null) {
                    return;
                }
                element.getKey().input(event.getMessage());
                return;
            }
        }
        try {
            Future<Boolean> ret = FocessQQ.CommandLine.exec(event.getMessage());
            EXECUTOR.run(() -> {
                block5: {
                    try {
                        if (!((Boolean)ret.get(10L, TimeUnit.MINUTES)).booleanValue()) {
                            ConsoleMessageEvent consoleMessageEvent = new ConsoleMessageEvent(event.getMessage());
                            try {
                                EventManager.submit(consoleMessageEvent);
                            }
                            catch (Exception e) {
                                FocessQQ.getLogger().thrLang("exception-submit-console-message-event", e, new Object[0]);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof InputTimeoutException || e instanceof TimeoutException) break block5;
                        FocessQQ.getLogger().thrLang("exception-exec-console-command", e, new Object[0]);
                    }
                }
            });
        }
        catch (Exception e) {
            FocessQQ.getLogger().thrLang("exception-exec-console-command", e, new Object[0]);
        }
    }

    public static void registerInputListener(IOHandler ioHandler) {
        QUESTS.add(Pair.of(ioHandler, System.currentTimeMillis()));
    }
}

