/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.schedule;

import com.google.common.collect.Queues;
import java.time.Duration;
import java.util.Queue;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.exceptions.SchedulerClosedException;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.api.schedule.Callback;
import top.focess.qq.api.schedule.Task;
import top.focess.qq.core.schedule.AScheduler;
import top.focess.qq.core.schedule.ComparableTask;
import top.focess.qq.core.schedule.FocessCallback;
import top.focess.qq.core.schedule.FocessTask;

public class FocessScheduler
extends AScheduler {
    private final Queue<ComparableTask> tasks = Queues.newPriorityBlockingQueue();
    private boolean shouldStop = false;

    public FocessScheduler(@NotNull Plugin plugin) {
        super(plugin);
        new SchedulerThread(this.getName()).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task run(Runnable runnable, Duration delay) {
        Queue<ComparableTask> queue = this.tasks;
        synchronized (queue) {
            if (this.shouldStop) {
                throw new SchedulerClosedException(this);
            }
            FocessTask task = new FocessTask(runnable, this);
            this.tasks.add(new ComparableTask(System.currentTimeMillis() + delay.toMillis(), task));
            this.tasks.notify();
            return task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task runTimer(Runnable runnable, Duration delay, Duration period) {
        Queue<ComparableTask> queue = this.tasks;
        synchronized (queue) {
            if (this.shouldStop) {
                throw new SchedulerClosedException(this);
            }
            FocessTask task = new FocessTask(runnable, period, this);
            this.tasks.add(new ComparableTask(System.currentTimeMillis() + delay.toMillis(), task));
            this.tasks.notify();
            return task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> Callback<V> submit(Callable<V> callable, Duration delay) {
        Queue<ComparableTask> queue = this.tasks;
        synchronized (queue) {
            if (this.shouldStop) {
                throw new SchedulerClosedException(this);
            }
            FocessCallback<V> callback = new FocessCallback<V>(callable, this);
            this.tasks.add(new ComparableTask(System.currentTimeMillis() + delay.toMillis(), callback));
            this.tasks.notify();
            return callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAll() {
        Queue<ComparableTask> queue = this.tasks;
        synchronized (queue) {
            this.tasks.clear();
        }
    }

    @Override
    public String getName() {
        return this.getPlugin().getName() + "-FocessScheduler";
    }

    @Override
    public void close() {
        super.close();
        this.shouldStop = true;
        this.cancelAll();
    }

    @Override
    public boolean isClosed() {
        return this.shouldStop;
    }

    private class SchedulerThread
    extends Thread {
        public SchedulerThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Queue queue = FocessScheduler.this.tasks;
                        synchronized (queue) {
                            ComparableTask task;
                            if (FocessScheduler.this.shouldStop) {
                                return;
                            }
                            if (FocessScheduler.this.tasks.isEmpty()) {
                                FocessScheduler.this.tasks.wait();
                            }
                            if ((task = (ComparableTask)FocessScheduler.this.tasks.peek()) != null) {
                                ComparableTask comparableTask = task;
                                synchronized (comparableTask) {
                                    if (task.isCancelled()) {
                                        FocessScheduler.this.tasks.poll();
                                        continue;
                                    }
                                    if (task.getTime() <= System.currentTimeMillis()) {
                                        FocessScheduler.this.tasks.poll();
                                        task.getTask().run();
                                        if (task.getTask().isPeriod()) {
                                            FocessScheduler.this.tasks.add(new ComparableTask(System.currentTimeMillis() + task.getTask().getPeriod().toMillis(), task.getTask()));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    FocessQQ.getLogger().thrLang("exception-focess-scheduler", e, new Object[0]);
                    continue;
                }
                break;
            }
        }
    }
}

