/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.schedule;

import top.focess.qq.FocessQQ;
import top.focess.qq.core.schedule.ITask;
import top.focess.qq.core.schedule.ThreadPoolScheduler;

public class ThreadPoolSchedulerThread
extends Thread {
    private final Object NOTIFY = new Object();
    private final ThreadPoolScheduler scheduler;
    private final String name;
    private boolean isAvailable = true;
    private ITask task;
    private boolean shouldStop = false;

    public ThreadPoolSchedulerThread(ThreadPoolScheduler scheduler, String name) {
        super(name);
        this.scheduler = scheduler;
        this.name = name;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object object = this.NOTIFY;
            synchronized (object) {
                try {
                    if (this.isAvailable) {
                        this.NOTIFY.wait();
                    }
                    if (this.shouldStop) {
                        break;
                    }
                    this.task.run();
                    this.isAvailable = true;
                }
                catch (Exception e) {
                    FocessQQ.getLogger().thrLang("exception-thread-pool-scheduler-thread", e, new Object[0]);
                }
            }
        }
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTask(ITask task) {
        Object object = this.NOTIFY;
        synchronized (object) {
            this.isAvailable = false;
            this.task = task;
            this.NOTIFY.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.NOTIFY;
        synchronized (object) {
            this.shouldStop = true;
            this.NOTIFY.notify();
        }
    }

    public void cancel() {
        this.stop();
        this.scheduler.recreate(this.name);
    }
}

