/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.mamoe.mirai.contact.MemberPermission;
import org.jetbrains.annotations.NotNull;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.command.CommandExecutor;
import top.focess.qq.api.command.CommandPermission;
import top.focess.qq.api.command.CommandResult;
import top.focess.qq.api.command.CommandResultExecutor;
import top.focess.qq.api.command.CommandSender;
import top.focess.qq.api.command.DataCollection;
import top.focess.qq.api.command.DataConverter;
import top.focess.qq.api.event.EventManager;
import top.focess.qq.api.event.command.CommandExecutedEvent;
import top.focess.qq.api.exceptions.CommandDuplicateException;
import top.focess.qq.api.exceptions.CommandLoadException;
import top.focess.qq.api.exceptions.EventSubmitException;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.api.util.IOHandler;

public abstract class Command {
    private static final Map<String, Command> COMMANDS_MAP = Maps.newConcurrentMap();
    private final List<Executor> executors = Lists.newArrayList();
    private String name;
    private List<String> aliases;
    private Plugin plugin;
    private boolean registered;
    private CommandPermission permission;
    private Predicate<CommandSender> executorPermission;
    private boolean initialize = false;

    public Command(@NotNull String name, String ... aliases) {
        this.name = name;
        this.aliases = Lists.newArrayList((Object[])aliases);
        this.permission = CommandPermission.MEMBER;
        this.executorPermission = i -> true;
        try {
            this.init();
        }
        catch (Exception e) {
            throw new CommandLoadException(this.getClass(), e);
        }
        this.initialize = true;
    }

    protected Command() {
        this.permission = CommandPermission.MEMBER;
        this.executorPermission = i -> true;
    }

    public void setExecutorPermission(@NotNull Predicate<CommandSender> executorPermission) {
        this.executorPermission = executorPermission;
    }

    public static void unregister(Plugin plugin) {
        for (Command command : COMMANDS_MAP.values()) {
            if (!command.getPlugin().equals(plugin)) continue;
            command.unregister();
        }
    }

    public static boolean unregisterAll() {
        boolean ret = false;
        for (Command command : COMMANDS_MAP.values()) {
            if (command.getPlugin() != FocessQQ.getMainPlugin()) {
                ret = true;
            }
            command.unregister();
        }
        return ret;
    }

    public static List<Command> getCommands() {
        return Lists.newArrayList(COMMANDS_MAP.values());
    }

    public static void register(@NotNull Plugin plugin, @NotNull Command command) {
        if (command.name == null) {
            throw new IllegalStateException("CommandType dose not contain name or the constructor does not super name");
        }
        if (COMMANDS_MAP.containsKey(command.getName())) {
            throw new CommandDuplicateException(command.getName());
        }
        command.registered = true;
        command.plugin = plugin;
        COMMANDS_MAP.put(command.getName(), command);
    }

    public boolean isRegistered() {
        return this.registered;
    }

    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    public void unregister() {
        this.registered = false;
        COMMANDS_MAP.remove(this.getName());
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }

    public Predicate<CommandSender> getExecutorPermission() {
        return this.executorPermission;
    }

    @NotNull
    public final Executor addExecutor(int count, @NotNull CommandExecutor executor, String ... subCommands) {
        Executor executor1 = new Executor(count, executor, (Predicate)this.executorPermission, this, subCommands);
        this.executors.add(executor1);
        return executor1;
    }

    public final boolean execute(@NotNull CommandSender sender, @NotNull String[] args, @NotNull IOHandler ioHandler) {
        if (!this.isRegistered()) {
            return false;
        }
        if (!sender.hasPermission(this.getPermission())) {
            return false;
        }
        int amount = args.length;
        boolean flag = false;
        CommandResult result = CommandResult.NONE;
        for (Executor executor : this.executors) {
            if (!executor.checkCount(amount) || !executor.checkArgs(args)) continue;
            result = sender.hasPermission(executor.permission) ? executor.execute(sender, Arrays.copyOfRange(args, executor.getSubCommandsSize(), args.length), ioHandler) : CommandResult.REFUSE;
            for (CommandResult r : executor.results.keySet()) {
                if ((r.getValue() & result.getValue()) == 0) continue;
                ((CommandResultExecutor)executor.results.get((Object)r)).execute(result);
            }
            CommandExecutedEvent event = new CommandExecutedEvent(executor, args, ioHandler, sender, result);
            try {
                EventManager.submit(event);
            }
            catch (EventSubmitException e) {
                FocessQQ.getLogger().thrLang("exception-submit-command-executed-event", e, new Object[0]);
            }
            flag = true;
        }
        if (!flag && this.executorPermission.test(sender) || result == CommandResult.ARGS) {
            this.usage(sender, ioHandler);
        }
        return true;
    }

    @NotNull
    public CommandPermission getPermission() {
        return this.permission;
    }

    @Deprecated
    public final void setPermission(@NotNull MemberPermission permission) {
        this.permission = CommandPermission.toCommandPermission(permission);
    }

    public abstract void init();

    public abstract void usage(CommandSender var1, IOHandler var2);

    public boolean isInitialize() {
        return this.initialize;
    }

    public void setPermission(CommandPermission permission) {
        this.permission = permission;
    }

    public static class Executor {
        private final int count;
        private final String[] subCommands;
        private final Map<CommandResult, CommandResultExecutor> results = Maps.newHashMap();
        private final CommandExecutor executor;
        private CommandPermission permission = CommandPermission.MEMBER;
        private DataConverter<?>[] dataConverters;
        private boolean useDefaultConverter = true;
        private Predicate<CommandSender> executorPermission;
        private final Command command;

        private Executor(int count, CommandExecutor executor, Predicate<CommandSender> executorPermission, Command command, String ... subCommands) {
            this.subCommands = subCommands;
            this.count = count;
            this.executor = executor;
            this.executorPermission = executorPermission;
            this.command = command;
        }

        private boolean checkArgs(String[] args) {
            return this.checkArgs(args, this.getSubCommandsSize());
        }

        private boolean checkArgs(String[] args, int count) {
            for (int i = 0; i < count; ++i) {
                if (this.subCommands[i].equals(args[i])) continue;
                return false;
            }
            return true;
        }

        private boolean checkCount(int amount) {
            return this.subCommands.length + this.count == amount;
        }

        private CommandResult execute(CommandSender sender, String[] args, IOHandler ioHandler) {
            int i;
            if (!this.executorPermission.test(sender)) {
                return CommandResult.REFUSE;
            }
            if (this.useDefaultConverter) {
                this.dataConverters = Collections.nCopies(args.length, DataConverter.DEFAULT_DATA_CONVERTER).toArray(new DataConverter[0]);
            } else if (this.dataConverters.length < args.length) {
                ArrayList dataConverters = Lists.newArrayList((Object[])this.dataConverters);
                for (i = 0; i < args.length - this.dataConverters.length; ++i) {
                    dataConverters.add(DataConverter.DEFAULT_DATA_CONVERTER);
                }
                this.dataConverters = dataConverters.toArray(new DataConverter[0]);
            }
            DataCollection dataCollection = new DataCollection(this.dataConverters);
            for (i = 0; i < args.length; ++i) {
                if (this.dataConverters[i].put(dataCollection, args[i])) continue;
                return CommandResult.ARGS;
            }
            dataCollection.flip();
            return this.executor.execute(sender, dataCollection, ioHandler);
        }

        private int getSubCommandsSize() {
            return this.subCommands.length;
        }

        @Deprecated
        @NotNull
        public Executor setPermission(@NotNull MemberPermission permission) {
            this.permission = CommandPermission.toCommandPermission(permission);
            return this;
        }

        @NotNull
        public Executor setPermission(@NotNull CommandPermission permission) {
            this.permission = permission;
            return this;
        }

        @NotNull
        public Executor setCommandResultExecutors(@NotNull CommandResult result, @NotNull CommandResultExecutor executor) {
            this.results.put(result, executor);
            return this;
        }

        @NotNull
        public Executor setDataConverters(DataConverter<?> ... dataConverters) {
            this.dataConverters = dataConverters;
            this.useDefaultConverter = false;
            return this;
        }

        @NotNull
        public Executor setUseDefaultConverter(boolean flag) {
            this.useDefaultConverter = flag;
            return this;
        }

        @NotNull
        public Executor setExecutorPermission(@NotNull Predicate<CommandSender> executorPermission) {
            this.executorPermission = this.executorPermission.and(executorPermission);
            return this;
        }

        @NotNull
        public Executor removeExecutorPermission() {
            this.executorPermission = i -> true;
            return this;
        }

        @NotNull
        public Executor overrideExecutorPermission(@NotNull Predicate<CommandSender> executorPermission) {
            this.executorPermission = executorPermission;
            return this;
        }

        public Command getCommand() {
            return this.command;
        }
    }
}

