/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.event;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.event.Event;
import top.focess.qq.api.event.ListenerHandler;
import top.focess.qq.api.exceptions.EventSubmitException;

public class EventManager {
    private static final Map<Class<? extends Event>, ListenerHandler> LISTENER_HANDLER_MAP = Maps.newHashMap();

    private static <T> T cast(Object t) {
        return (T)t;
    }

    public static <T extends Event> void submit(T event) throws EventSubmitException {
        EventManager.submit((Class)EventManager.cast(event.getClass()), event);
    }

    public static <T extends Event> void submit(Class<T> cls, T event) throws EventSubmitException {
        if (!Modifier.isAbstract(cls.getModifiers())) {
            ListenerHandler listenerHandler = LISTENER_HANDLER_MAP.get(cls);
            if (listenerHandler == null) {
                try {
                    Field field = cls.getDeclaredField("LISTENER_HANDLER");
                    boolean flag = field.isAccessible();
                    field.setAccessible(true);
                    listenerHandler = (ListenerHandler)field.get(null);
                    field.setAccessible(flag);
                    LISTENER_HANDLER_MAP.put(cls, listenerHandler);
                }
                catch (Exception e) {
                    throw new EventSubmitException(event, "This event doesn't contain a LISTENER_HANDLER field.");
                }
            }
            listenerHandler.submit(event);
            Class<T> c = cls;
            while (!(c = c.getSuperclass()).equals(Event.class)) {
                EventManager.trySubmitOnce((Class)EventManager.cast(c), event);
            }
        } else {
            throw new EventSubmitException(event, "This event is an abstract class.");
        }
    }

    public static <T extends Event> void trySubmitOnce(Class<T> cls, T event) {
        try {
            EventManager.submitOnce(cls, event);
        }
        catch (EventSubmitException e) {
            FocessQQ.getLogger().trace("Try Submit Failed", e);
        }
    }

    public static <T extends Event> void submitOnce(Class<T> cls, T event) throws EventSubmitException {
        ListenerHandler listenerHandler;
        if (!Modifier.isAbstract(cls.getModifiers())) {
            listenerHandler = LISTENER_HANDLER_MAP.get(cls);
            if (listenerHandler == null) {
                try {
                    Field field = cls.getDeclaredField("LISTENER_HANDLER");
                    boolean flag = field.isAccessible();
                    field.setAccessible(true);
                    listenerHandler = (ListenerHandler)field.get(null);
                    field.setAccessible(flag);
                    LISTENER_HANDLER_MAP.put(cls, listenerHandler);
                }
                catch (Exception e) {
                    throw new EventSubmitException(event, "This event doesn't contain a LISTENER_HANDLER field.");
                }
            }
        } else {
            throw new EventSubmitException(event, "This event is an abstract class.");
        }
        listenerHandler.submit(event);
    }
}

