/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.net;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import org.jetbrains.annotations.Nullable;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.net.Client;
import top.focess.qq.api.net.PackHandler;
import top.focess.qq.api.net.ServerReceiver;
import top.focess.qq.api.net.packet.ClientPackPacket;
import top.focess.qq.api.net.packet.ConnectedPacket;
import top.focess.qq.api.net.packet.DisconnectPacket;
import top.focess.qq.api.net.packet.DisconnectedPacket;
import top.focess.qq.api.net.packet.HeartPacket;
import top.focess.qq.api.net.packet.Packet;
import top.focess.qq.api.net.packet.ServerPackPacket;
import top.focess.qq.api.net.packet.SidedConnectPacket;
import top.focess.qq.api.net.packet.WaitPacket;
import top.focess.qq.api.schedule.Scheduler;
import top.focess.qq.api.schedule.Schedulers;
import top.focess.qq.core.net.PacketHandler;
import top.focess.qq.core.net.SimpleClient;

public class FocessSidedReceiver
implements ServerReceiver {
    private final Map<Integer, SimpleClient> clientInfos = Maps.newConcurrentMap();
    private final Map<Integer, Long> lastHeart = Maps.newConcurrentMap();
    private final Map<String, Map<Class<?>, List<PackHandler>>> packHandlers = Maps.newHashMap();
    private final Map<String, Queue<Packet>> packets = Maps.newConcurrentMap();
    private int defaultClientId = 0;
    private final Scheduler scheduler = Schedulers.newFocessScheduler(FocessQQ.getMainPlugin());

    public FocessSidedReceiver() {
        this.scheduler.runTimer(() -> {
            for (SimpleClient simpleClient : this.clientInfos.values()) {
                long time = this.lastHeart.getOrDefault(simpleClient.getId(), 0L);
                if (System.currentTimeMillis() - time <= 10000L) continue;
                this.clientInfos.remove(simpleClient.getId());
            }
        }, Duration.ZERO, Duration.ofSeconds(1L));
    }

    @PacketHandler
    public ConnectedPacket onConnect(SidedConnectPacket packet) {
        for (SimpleClient simpleClient : this.clientInfos.values()) {
            if (!simpleClient.getName().equals(packet.getName())) continue;
            return null;
        }
        SimpleClient simpleClient = new SimpleClient(this.defaultClientId++, packet.getName(), FocessSidedReceiver.generateToken());
        this.lastHeart.put(simpleClient.getId(), System.currentTimeMillis());
        this.clientInfos.put(simpleClient.getId(), simpleClient);
        return new ConnectedPacket(simpleClient.getId(), simpleClient.getToken());
    }

    @PacketHandler
    public DisconnectedPacket onDisconnect(DisconnectPacket packet) {
        SimpleClient simpleClient;
        if (this.clientInfos.get(packet.getClientId()) != null && (simpleClient = this.clientInfos.get(packet.getClientId())).getToken().equals(packet.getToken())) {
            return this.disconnect(packet.getClientId());
        }
        return null;
    }

    @PacketHandler
    public Packet onHeart(HeartPacket packet) {
        SimpleClient simpleClient;
        if (this.clientInfos.get(packet.getClientId()) != null && (simpleClient = this.clientInfos.get(packet.getClientId())).getToken().equals(packet.getToken()) && System.currentTimeMillis() + 5000L > packet.getTime()) {
            this.lastHeart.put(simpleClient.getId(), packet.getTime());
            return this.packets.getOrDefault(simpleClient.getName(), Queues.newConcurrentLinkedQueue()).poll();
        }
        return null;
    }

    @PacketHandler
    public Packet onClientPacket(ClientPackPacket packet) {
        SimpleClient simpleClient;
        if (this.clientInfos.get(packet.getClientId()) != null && (simpleClient = this.clientInfos.get(packet.getClientId())).getToken().equals(packet.getToken())) {
            for (PackHandler packHandler : (List)((Map)this.packHandlers.getOrDefault(simpleClient.getName(), Maps.newHashMap())).getOrDefault(packet.getPacket().getClass(), Lists.newArrayList())) {
                packHandler.handle(packet.getPacket());
            }
            return this.packets.getOrDefault(simpleClient.getName(), Queues.newConcurrentLinkedQueue()).poll();
        }
        return null;
    }

    @PacketHandler
    public Packet onWait(WaitPacket packet) {
        SimpleClient simpleClient;
        if (this.clientInfos.get(packet.getClientId()) != null && (simpleClient = this.clientInfos.get(packet.getClientId())).getToken().equals(packet.getToken())) {
            return this.packets.getOrDefault(simpleClient.getName(), Queues.newConcurrentLinkedQueue()).poll();
        }
        return null;
    }

    @Override
    public void sendPacket(String client, Packet packet) {
        this.packets.compute(client, (k, v) -> {
            if (v == null) {
                v = Queues.newConcurrentLinkedQueue();
            }
            v.offer(new ServerPackPacket(packet));
            return v;
        });
    }

    private DisconnectedPacket disconnect(int clientId) {
        this.clientInfos.remove(clientId);
        return new DisconnectedPacket();
    }

    private static String generateToken() {
        StringBuilder stringBuilder = new StringBuilder();
        Random random = new Random(System.currentTimeMillis());
        block5: for (int i = 0; i < 64; ++i) {
            switch (random.nextInt(3)) {
                case 0: {
                    stringBuilder.append((char)(48 + random.nextInt(10)));
                    continue block5;
                }
                case 1: {
                    stringBuilder.append((char)(97 + random.nextInt(26)));
                    continue block5;
                }
                case 2: {
                    stringBuilder.append((char)(65 + random.nextInt(26)));
                }
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public <T extends Packet> void registerPackHandler(String name, Class<T> c, PackHandler<T> packHandler) {
        this.packHandlers.compute(name, (k, v) -> {
            if (v == null) {
                v = Maps.newHashMap();
            }
            v.compute(c, (k1, v1) -> {
                if (v1 == null) {
                    v1 = Lists.newArrayList();
                }
                v1.add(packHandler);
                return v1;
            });
            return v;
        });
    }

    @Override
    public void close() {
        this.scheduler.close();
        for (Integer id : this.clientInfos.keySet()) {
            this.disconnect(id);
        }
    }

    @Override
    public boolean isConnected(String client) {
        for (Integer id : this.clientInfos.keySet()) {
            if (!this.clientInfos.get(id).getName().equals(client)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Client getClient(String name) {
        for (SimpleClient simpleClient : this.clientInfos.values()) {
            if (!simpleClient.getName().equals(name)) continue;
            return simpleClient;
        }
        return null;
    }
}

