/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.net;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.ServerSocket;
import java.util.List;
import java.util.Map;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.exceptions.IllegalPortException;
import top.focess.qq.api.net.PacketPreCodec;
import top.focess.qq.api.net.Receiver;
import top.focess.qq.api.net.Socket;
import top.focess.qq.api.net.packet.Packet;
import top.focess.qq.api.util.Pair;
import top.focess.qq.core.net.PacketHandler;

public class FocessSidedSocket
implements Socket {
    private final Map<Class<? extends Packet>, List<Pair<Receiver, Method>>> packetMethods = Maps.newHashMap();
    private final List<Receiver> receivers = Lists.newArrayList();
    private final int localPort;
    private final ServerSocket server;
    private final Thread thread;

    public FocessSidedSocket(int localPort) throws IllegalPortException {
        this.localPort = localPort;
        try {
            this.server = new ServerSocket(localPort);
        }
        catch (IOException e) {
            throw new IllegalPortException(localPort);
        }
        this.thread = new Thread(() -> {
            FocessQQ.getLogger().debugLang("start-focess-sided-socket", localPort);
            while (!this.server.isClosed()) {
                try {
                    int length;
                    java.net.Socket socket = this.server.accept();
                    InputStream inputStream = socket.getInputStream();
                    byte[] buffer = new byte[1024];
                    PacketPreCodec packetPreCodec = new PacketPreCodec();
                    while ((length = inputStream.read(buffer)) != -1) {
                        packetPreCodec.push(buffer, length);
                    }
                    Packet packet = packetPreCodec.readPacket();
                    OutputStream outputStream = socket.getOutputStream();
                    if (packet != null) {
                        for (Pair<Receiver, Method> pair : this.packetMethods.getOrDefault(packet.getClass(), Lists.newArrayList())) {
                            Method method = pair.getValue();
                            try {
                                method.setAccessible(true);
                                Object o = method.invoke((Object)pair.getKey(), packet);
                                if (o == null) continue;
                                PacketPreCodec handler = new PacketPreCodec();
                                handler.writePacket((Packet)o);
                                outputStream.write(handler.getBytes());
                                outputStream.flush();
                            }
                            catch (Exception e) {
                                FocessQQ.getLogger().thrLang("exception-handle-packet", e, new Object[0]);
                            }
                        }
                    }
                    socket.shutdownOutput();
                }
                catch (IOException e) {
                    FocessQQ.getLogger().thrLang("exception-focess-sided-socket", e, new Object[0]);
                    if (!this.server.isClosed()) continue;
                    return;
                }
            }
        });
        this.thread.start();
    }

    @Override
    public void close() {
        try {
            this.server.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (Receiver receiver : this.receivers) {
            receiver.close();
        }
    }

    @Override
    public void registerReceiver(Receiver receiver) {
        this.receivers.add(receiver);
        for (Method method : receiver.getClass().getDeclaredMethods()) {
            Class<?> packetClass;
            PacketHandler handler = method.getAnnotation(PacketHandler.class);
            if (handler == null || method.getParameterTypes().length != 1 || !method.getReturnType().equals(Void.TYPE) && !Packet.class.isAssignableFrom(method.getReturnType()) || !Packet.class.isAssignableFrom(packetClass = method.getParameterTypes()[0]) || Modifier.isAbstract(packetClass.getModifiers())) continue;
            try {
                this.packetMethods.compute(packetClass, (k, v) -> {
                    if (v == null) {
                        v = Lists.newArrayList();
                    }
                    v.add(Pair.of(receiver, method));
                    return v;
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean containsServerSide() {
        return true;
    }

    @Override
    public boolean containsClientSide() {
        return false;
    }

    public int getLocalPort() {
        return this.localPort;
    }
}

