/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.net;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.net.Client;
import top.focess.qq.api.net.PackHandler;
import top.focess.qq.api.net.ServerMultiReceiver;
import top.focess.qq.api.net.packet.ClientPackPacket;
import top.focess.qq.api.net.packet.ConnectPacket;
import top.focess.qq.api.net.packet.ConnectedPacket;
import top.focess.qq.api.net.packet.DisconnectPacket;
import top.focess.qq.api.net.packet.DisconnectedPacket;
import top.focess.qq.api.net.packet.HeartPacket;
import top.focess.qq.api.net.packet.Packet;
import top.focess.qq.api.net.packet.ServerPackPacket;
import top.focess.qq.api.schedule.Scheduler;
import top.focess.qq.api.schedule.Schedulers;
import top.focess.qq.core.net.FocessUDPSocket;
import top.focess.qq.core.net.PacketHandler;
import top.focess.qq.core.net.SimpleClient;

public class FocessUDPMultiReceiver
implements ServerMultiReceiver {
    private final Map<Integer, SimpleClient> clientInfos = Maps.newConcurrentMap();
    private final Map<Integer, Long> lastHeart = Maps.newConcurrentMap();
    private final Map<String, Map<Class<?>, List<PackHandler>>> packHandlers = Maps.newHashMap();
    private final FocessUDPSocket focessUDPSocket;
    private int defaultClientId = 0;
    private final Scheduler scheduler = Schedulers.newFocessScheduler(FocessQQ.getMainPlugin());

    public FocessUDPMultiReceiver(FocessUDPSocket focessUDPSocket) {
        this.focessUDPSocket = focessUDPSocket;
        this.scheduler.runTimer(() -> {
            for (SimpleClient simpleClient : this.clientInfos.values()) {
                long time = this.lastHeart.getOrDefault(simpleClient.getId(), 0L);
                if (System.currentTimeMillis() - time <= 10000L) continue;
                this.clientInfos.remove(simpleClient.getId());
            }
        }, Duration.ZERO, Duration.ofSeconds(1L));
    }

    private void disconnect(int clientId) {
        SimpleClient simpleClient = this.clientInfos.remove(clientId);
        if (simpleClient != null) {
            this.focessUDPSocket.sendPacket(simpleClient.getHost(), simpleClient.getPort(), new DisconnectedPacket());
        }
    }

    @Override
    public void close() {
        this.scheduler.close();
        for (Integer id : this.clientInfos.keySet()) {
            this.disconnect(id);
        }
    }

    @PacketHandler
    public void onConnect(ConnectPacket packet) {
        SimpleClient simpleClient = new SimpleClient(packet.getHost(), packet.getPort(), this.defaultClientId++, packet.getName(), FocessUDPMultiReceiver.generateToken());
        this.lastHeart.put(simpleClient.getId(), System.currentTimeMillis());
        this.clientInfos.put(simpleClient.getId(), simpleClient);
        this.focessUDPSocket.sendPacket(packet.getHost(), packet.getPort(), new ConnectedPacket(simpleClient.getId(), simpleClient.getToken()));
    }

    @PacketHandler
    public void onDisconnect(DisconnectPacket packet) {
        SimpleClient simpleClient;
        if (this.clientInfos.get(packet.getClientId()) != null && (simpleClient = this.clientInfos.get(packet.getClientId())).getToken().equals(packet.getToken())) {
            this.disconnect(packet.getClientId());
        }
    }

    @PacketHandler
    public void onHeart(HeartPacket packet) {
        SimpleClient simpleClient;
        if (this.clientInfos.get(packet.getClientId()) != null && (simpleClient = this.clientInfos.get(packet.getClientId())).getToken().equals(packet.getToken())) {
            this.lastHeart.put(simpleClient.getId(), System.currentTimeMillis());
        }
    }

    @PacketHandler
    public void onClientPacket(ClientPackPacket packet) {
        SimpleClient simpleClient;
        if (this.clientInfos.get(packet.getClientId()) != null && (simpleClient = this.clientInfos.get(packet.getClientId())).getToken().equals(packet.getToken())) {
            for (PackHandler packHandler : (List)((Map)this.packHandlers.getOrDefault(simpleClient.getName(), Maps.newHashMap())).getOrDefault(packet.getPacket().getClass(), Lists.newArrayList())) {
                packHandler.handle(packet.getPacket());
            }
        }
    }

    @Override
    public void sendPacket(String client, Packet packet) {
        for (SimpleClient simpleClient : this.clientInfos.values()) {
            if (!simpleClient.getName().equals(client)) continue;
            this.focessUDPSocket.sendPacket(simpleClient.getHost(), simpleClient.getPort(), new ServerPackPacket(packet));
        }
    }

    @Override
    public <T extends Packet> void registerPackHandler(String name, Class<T> c, PackHandler<T> packHandler) {
        this.packHandlers.compute(name, (k, v) -> {
            if (v == null) {
                v = Maps.newHashMap();
            }
            v.compute(c, (k1, v1) -> {
                if (v1 == null) {
                    v1 = Lists.newArrayList();
                }
                v1.add(packHandler);
                return v1;
            });
            return v;
        });
    }

    private static String generateToken() {
        StringBuilder stringBuilder = new StringBuilder();
        Random random = new Random(System.currentTimeMillis());
        block5: for (int i = 0; i < 64; ++i) {
            switch (random.nextInt(3)) {
                case 0: {
                    stringBuilder.append((char)(48 + random.nextInt(10)));
                    continue block5;
                }
                case 1: {
                    stringBuilder.append((char)(97 + random.nextInt(26)));
                    continue block5;
                }
                case 2: {
                    stringBuilder.append((char)(65 + random.nextInt(26)));
                }
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isConnected(String client) {
        for (Integer id : this.clientInfos.keySet()) {
            if (!this.clientInfos.get(id).getName().equals(client)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void sendPacket(int id, Packet packet) {
        SimpleClient simpleClient = this.clientInfos.get(id);
        if (simpleClient != null) {
            this.focessUDPSocket.sendPacket(simpleClient.getHost(), simpleClient.getPort(), packet);
        }
    }

    @Override
    public List<Client> getClients(String name) {
        ArrayList ret = Lists.newArrayList();
        for (SimpleClient client : this.clientInfos.values()) {
            if (!client.getName().equals(name)) continue;
            ret.add(client);
        }
        return ret;
    }
}

