/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.util;

import java.util.Arrays;
import org.jetbrains.annotations.Nullable;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.exceptions.InputTimeoutException;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.core.listener.ConsoleListener;
import top.focess.qq.core.plugin.PluginCoreClassLoader;
import top.focess.qq.core.util.MethodCaller;

public abstract class IOHandler {
    private static volatile IOHandler CONSOLE_IO_HANDLER = new IOHandler(){

        @Override
        public void output(String output) {
            String[] messages = output.split("\n");
            Arrays.stream(messages).forEachOrdered(FocessQQ.getLogger()::info);
        }

        @Override
        public boolean hasInput(boolean flag) {
            ConsoleListener.registerInputListener(this);
            while (!this.flag) {
            }
            return true;
        }
    };
    protected volatile String value = null;
    protected volatile boolean flag = false;

    public static IOHandler getConsoleIoHandler() {
        return CONSOLE_IO_HANDLER;
    }

    public static void setConsoleIoHandler(IOHandler consoleIoHandler) {
        CONSOLE_IO_HANDLER = consoleIoHandler;
    }

    public abstract void output(String var1);

    public void outputLang(String key, Object ... objects) {
        Plugin plugin = PluginCoreClassLoader.getClassLoadedBy(MethodCaller.getCallerClass());
        if (plugin == null) {
            this.output(String.format(FocessQQ.getLangConfig().get(key), objects));
        } else {
            this.output(String.format(plugin.getLangConfig().get(key), objects));
        }
    }

    public String input() {
        if (!this.flag) {
            this.hasInput();
        }
        this.flag = false;
        if (this.value == null) {
            throw new InputTimeoutException();
        }
        return this.value;
    }

    public void input(@Nullable String input) {
        this.value = input;
        this.flag = true;
    }

    public boolean hasInput() {
        return this.hasInput(false);
    }

    public abstract boolean hasInput(boolean var1);
}

