/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.net;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.net.PackHandler;
import top.focess.qq.api.net.packet.ClientPackPacket;
import top.focess.qq.api.net.packet.ConnectPacket;
import top.focess.qq.api.net.packet.ConnectedPacket;
import top.focess.qq.api.net.packet.DisconnectPacket;
import top.focess.qq.api.net.packet.DisconnectedPacket;
import top.focess.qq.api.net.packet.HeartPacket;
import top.focess.qq.api.net.packet.Packet;
import top.focess.qq.api.net.packet.ServerPackPacket;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.api.schedule.Scheduler;
import top.focess.qq.api.schedule.Schedulers;
import top.focess.qq.core.net.AServerReceiver;
import top.focess.qq.core.net.FocessSocket;
import top.focess.qq.core.net.PacketHandler;
import top.focess.qq.core.net.SimpleClient;

public class FocessReceiver
extends AServerReceiver {
    private final FocessSocket focessSocket;
    private final Scheduler scheduler = Schedulers.newFocessScheduler(FocessQQ.getMainPlugin());

    public FocessReceiver(FocessSocket focessSocket) {
        this.focessSocket = focessSocket;
        this.scheduler.runTimer(() -> {
            for (SimpleClient simpleClient : this.clientInfos.values()) {
                long time = this.lastHeart.getOrDefault(simpleClient.getId(), 0L);
                if (System.currentTimeMillis() - time <= 10000L) continue;
                this.clientInfos.remove(simpleClient.getId());
            }
        }, Duration.ZERO, Duration.ofSeconds(1L));
    }

    @PacketHandler
    public void onConnect(ConnectPacket packet) {
        for (SimpleClient simpleClient : this.clientInfos.values()) {
            if (!simpleClient.getName().equals(packet.getName())) continue;
            return;
        }
        SimpleClient simpleClient = new SimpleClient(packet.getHost(), packet.getPort(), this.defaultClientId++, packet.getName(), FocessReceiver.generateToken());
        this.lastHeart.put(simpleClient.getId(), System.currentTimeMillis());
        this.clientInfos.put(simpleClient.getId(), simpleClient);
        this.focessSocket.sendPacket(packet.getHost(), packet.getPort(), new ConnectedPacket(simpleClient.getId(), simpleClient.getToken()));
    }

    @PacketHandler
    public void onDisconnect(DisconnectPacket packet) {
        SimpleClient simpleClient;
        if (this.clientInfos.get(packet.getClientId()) != null && (simpleClient = (SimpleClient)this.clientInfos.get(packet.getClientId())).getToken().equals(packet.getToken())) {
            this.disconnect(packet.getClientId());
        }
    }

    @PacketHandler
    public void onHeart(HeartPacket packet) {
        SimpleClient simpleClient;
        if (this.clientInfos.get(packet.getClientId()) != null && (simpleClient = (SimpleClient)this.clientInfos.get(packet.getClientId())).getToken().equals(packet.getToken()) && System.currentTimeMillis() + 5000L > packet.getTime()) {
            this.lastHeart.put(simpleClient.getId(), packet.getTime());
        }
    }

    @PacketHandler
    public void onClientPacket(ClientPackPacket packet) {
        SimpleClient simpleClient;
        if (this.clientInfos.get(packet.getClientId()) != null && (simpleClient = (SimpleClient)this.clientInfos.get(packet.getClientId())).getToken().equals(packet.getToken())) {
            for (Plugin plugin : this.packHandlers.keySet()) {
                for (PackHandler packHandler : (List)((Map)((Map)this.packHandlers.get(plugin)).getOrDefault(simpleClient.getName(), Maps.newHashMap())).getOrDefault(packet.getPacket().getClass(), Lists.newArrayList())) {
                    packHandler.handle(packet.getPacket());
                }
            }
        }
    }

    private void disconnect(int clientId) {
        SimpleClient simpleClient = (SimpleClient)this.clientInfos.remove(clientId);
        if (simpleClient != null) {
            this.focessSocket.sendPacket(simpleClient.getHost(), simpleClient.getPort(), new DisconnectedPacket());
        }
    }

    @Override
    public void sendPacket(String client, Packet packet) {
        for (SimpleClient simpleClient : this.clientInfos.values()) {
            if (!simpleClient.getName().equals(client)) continue;
            this.focessSocket.sendPacket(simpleClient.getHost(), simpleClient.getPort(), new ServerPackPacket(packet));
        }
    }

    @Override
    public void close() {
        this.scheduler.close();
        for (Integer id : this.clientInfos.keySet()) {
            this.disconnect(id);
        }
    }
}

