/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.net;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.net.PackHandler;
import top.focess.qq.api.net.packet.ClientPackPacket;
import top.focess.qq.api.net.packet.ConnectedPacket;
import top.focess.qq.api.net.packet.DisconnectedPacket;
import top.focess.qq.api.net.packet.HeartPacket;
import top.focess.qq.api.net.packet.Packet;
import top.focess.qq.api.net.packet.ServerPackPacket;
import top.focess.qq.api.net.packet.SidedConnectPacket;
import top.focess.qq.api.net.packet.WaitPacket;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.api.schedule.Scheduler;
import top.focess.qq.api.schedule.Schedulers;
import top.focess.qq.core.net.AClientReceiver;
import top.focess.qq.core.net.FocessSidedClientSocket;
import top.focess.qq.core.net.PacketHandler;

public class FocessSidedClientReceiver
extends AClientReceiver {
    private final FocessSidedClientSocket focessSidedClientSocket;
    private final Scheduler scheduler = Schedulers.newFocessScheduler(FocessQQ.getMainPlugin());
    private final Queue<Packet> packets = Queues.newConcurrentLinkedQueue();

    public FocessSidedClientReceiver(FocessSidedClientSocket focessSidedClientSocket, String name) {
        super(focessSidedClientSocket.getHost(), focessSidedClientSocket.getPort(), name);
        this.focessSidedClientSocket = focessSidedClientSocket;
        this.scheduler.runTimer(() -> {
            if (this.connected) {
                this.packets.offer(new HeartPacket(this.id, this.token, System.currentTimeMillis()));
            } else {
                focessSidedClientSocket.sendPacket(new SidedConnectPacket(name));
            }
        }, Duration.ZERO, Duration.ofSeconds(2L));
        this.scheduler.runTimer(() -> {
            if (this.connected) {
                Packet packet = this.packets.poll();
                if (packet == null) {
                    packet = new WaitPacket(this.id, this.token);
                }
                focessSidedClientSocket.sendPacket(packet);
            }
        }, Duration.ZERO, Duration.ofMillis(100L));
    }

    @Override
    public void sendPacket(Packet packet) {
        this.packets.add(new ClientPackPacket(this.id, this.token, packet));
    }

    @PacketHandler
    public void onConnected(ConnectedPacket packet) {
        if (this.connected) {
            return;
        }
        this.token = packet.getToken();
        this.id = packet.getClientId();
        this.connected = true;
    }

    @PacketHandler
    public void onDisconnected(DisconnectedPacket packet) {
        this.connected = false;
        this.focessSidedClientSocket.sendPacket(new SidedConnectPacket(this.name));
    }

    @PacketHandler
    public void onServerPacket(ServerPackPacket packet) {
        for (Plugin plugin : this.packHandlers.keySet()) {
            for (PackHandler packHandler : (List)((Map)this.packHandlers.get(plugin)).getOrDefault(packet.getPacket().getClass(), Lists.newArrayList())) {
                packHandler.handle(packet.getPacket());
            }
        }
    }

    @Override
    public void close() {
        this.scheduler.close();
    }
}

