/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.schedule;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.exceptions.TaskNotFinishedException;
import top.focess.qq.api.schedule.Callback;
import top.focess.qq.api.schedule.Scheduler;
import top.focess.qq.api.schedule.Schedulers;
import top.focess.qq.api.schedule.Task;
import top.focess.qq.core.schedule.FocessTask;

public class FocessCallback<V>
extends FocessTask
implements Callback<V> {
    private static final Scheduler DEFAULT_SCHEDULER = Schedulers.newThreadPoolScheduler(FocessQQ.getMainPlugin(), 10);
    private final Callable<V> callback;
    private V value;

    FocessCallback(Callable<V> callback, Scheduler scheduler) {
        super(null, scheduler);
        this.callback = callback;
    }

    @Override
    public V call() throws TaskNotFinishedException, CancellationException, ExecutionException {
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        if (!this.isFinished) {
            throw new TaskNotFinishedException(this);
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        AtomicBoolean out = new AtomicBoolean(false);
        Task task = DEFAULT_SCHEDULER.run(() -> {
            out.set(true);
            FocessCallback focessCallback = this;
            synchronized (focessCallback) {
                this.notifyAll();
            }
        }, Duration.ofMillis(unit.toMillis(timeout)));
        FocessCallback focessCallback = this;
        synchronized (focessCallback) {
            block4: {
                do {
                    this.wait();
                    if (this.isCancelled() || this.isFinished()) break block4;
                } while (!out.get());
                throw new TimeoutException();
            }
        }
        task.cancel();
        return this.call();
    }

    @Override
    public void run() throws ExecutionException {
        try {
            this.value = this.callback.call();
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public synchronized void endRun() {
        super.endRun();
        this.notifyAll();
    }
}

