/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.util.network;

import java.util.function.Function;
import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.focess.qq.api.exceptions.HttpResponseException;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.api.util.json.JSON;

public class HttpResponse {
    public static final int UNKNOWN_REQUEST = -1;
    public static final int EXCEPTION = -2;
    private static final Function<Plugin, HttpResponse> UNKNOWN_REQUEST_TYPE = HttpResponse::new;
    private final int code;
    private final Plugin plugin;
    private Headers headers;
    private String value;
    private Exception exception;

    private HttpResponse(Plugin plugin, int code) {
        this.code = code;
        this.plugin = plugin;
    }

    private HttpResponse(Plugin plugin) {
        this(plugin, -1);
    }

    public HttpResponse(Plugin plugin, Exception e) {
        this(plugin, -2);
        this.exception = e;
    }

    public HttpResponse(Plugin plugin, int code, Headers headers, String value) {
        this(plugin, code);
        this.value = value;
        this.headers = headers;
    }

    public static HttpResponse ofNull(Plugin plugin) {
        return UNKNOWN_REQUEST_TYPE.apply(plugin);
    }

    @Nullable
    public Exception getException() {
        return this.exception;
    }

    public int getCode() {
        return this.code;
    }

    @NotNull
    public JSON getAsJSON() {
        if (this.isError()) {
            throw new HttpResponseException();
        }
        return new JSON(this.value);
    }

    @Nullable
    public String getResponse() {
        return this.value;
    }

    @Nullable
    public Headers getHeaders() {
        return this.headers;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public boolean isError() {
        return this.code == -2;
    }
}

