/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.schedule;

import com.google.common.collect.Queues;
import java.time.Duration;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.exceptions.SchedulerClosedException;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.api.schedule.Callback;
import top.focess.qq.api.schedule.Scheduler;
import top.focess.qq.api.schedule.Task;
import top.focess.qq.core.schedule.AScheduler;
import top.focess.qq.core.schedule.ComparableTask;
import top.focess.qq.core.schedule.FocessCallback;
import top.focess.qq.core.schedule.FocessTask;
import top.focess.qq.core.schedule.ITask;

public class FocessScheduler
extends AScheduler {
    private final Queue<ComparableTask> tasks = Queues.newPriorityBlockingQueue();
    private final String name = this.getPlugin().getName() + "-FocessScheduler-" + UUID.randomUUID().toString().substring(0, 8);
    private boolean shouldStop = false;

    public FocessScheduler(@NotNull Plugin plugin) {
        super(plugin);
        new SchedulerThread(this.getName()).start();
    }

    @Override
    public synchronized Task run(Runnable runnable, Duration delay) {
        if (this.shouldStop) {
            throw new SchedulerClosedException(this);
        }
        FocessTask task = new FocessTask(runnable, this);
        this.tasks.add(new ComparableTask(System.currentTimeMillis() + delay.toMillis(), task));
        this.notify();
        return task;
    }

    @Override
    public synchronized Task runTimer(Runnable runnable, Duration delay, Duration period) {
        if (this.shouldStop) {
            throw new SchedulerClosedException(this);
        }
        FocessTask task = new FocessTask(runnable, period, this);
        this.tasks.add(new ComparableTask(System.currentTimeMillis() + delay.toMillis(), task));
        this.notify();
        return task;
    }

    @Override
    public synchronized <V> Callback<V> submit(Callable<V> callable, Duration delay) {
        if (this.shouldStop) {
            throw new SchedulerClosedException(this);
        }
        FocessCallback<V> callback = new FocessCallback<V>(callable, (Scheduler)this);
        this.tasks.add(new ComparableTask(System.currentTimeMillis() + delay.toMillis(), callback));
        this.notify();
        return callback;
    }

    @Override
    public void cancelAll() {
        this.tasks.clear();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized void close() {
        super.close();
        this.shouldStop = true;
        this.cancelAll();
        this.notify();
    }

    @Override
    public boolean isClosed() {
        return this.shouldStop;
    }

    public String toString() {
        return this.getName();
    }

    private class SchedulerThread
    extends Thread {
        public SchedulerThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (!FocessScheduler.this.shouldStop) {
                        FocessScheduler focessScheduler = FocessScheduler.this;
                        synchronized (focessScheduler) {
                            if (FocessScheduler.this.tasks.isEmpty()) {
                                FocessScheduler.this.wait();
                            }
                        }
                        ComparableTask task = (ComparableTask)FocessScheduler.this.tasks.peek();
                        if (task != null) {
                            ITask iTask = task.getTask();
                            synchronized (iTask) {
                                if (task.isCancelled()) {
                                    FocessScheduler.this.tasks.poll();
                                    continue;
                                }
                                if (task.getTime() <= System.currentTimeMillis()) {
                                    FocessScheduler.this.tasks.poll();
                                    task.getTask().startRun();
                                }
                            }
                            if (task.getTask().isRunning()) {
                                try {
                                    task.getTask().run();
                                }
                                catch (ExecutionException e) {
                                    task.getTask().setException(e);
                                }
                                task.getTask().endRun();
                                if (task.getTask().isPeriod()) {
                                    FocessScheduler.this.tasks.add(new ComparableTask(System.currentTimeMillis() + task.getTask().getPeriod().toMillis(), task.getTask()));
                                }
                            }
                        }
                        SchedulerThread.sleep(0L);
                    }
                }
                catch (Exception e) {
                    FocessQQ.getLogger().thrLang("exception-focess-scheduler", e, new Object[0]);
                    continue;
                }
                break;
            }
        }
    }
}

