/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.schedule;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.Callable;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.exceptions.SchedulerClosedException;
import top.focess.qq.api.exceptions.TaskNotFoundException;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.api.schedule.Callback;
import top.focess.qq.api.schedule.Scheduler;
import top.focess.qq.api.schedule.Task;
import top.focess.qq.core.schedule.AScheduler;
import top.focess.qq.core.schedule.ComparableTask;
import top.focess.qq.core.schedule.FocessCallback;
import top.focess.qq.core.schedule.FocessTask;
import top.focess.qq.core.schedule.ITask;
import top.focess.qq.core.schedule.ThreadPoolSchedulerThread;

public class ThreadPoolScheduler
extends AScheduler {
    private final Queue<ComparableTask> tasks = Queues.newPriorityBlockingQueue();
    private final Map<ITask, ThreadPoolSchedulerThread> taskThreadMap = Maps.newConcurrentMap();
    private final List<ThreadPoolSchedulerThread> threads = Lists.newArrayList();
    private boolean shouldStop = false;
    private int currentThread = 0;
    private final String name = this.getPlugin().getName() + "-ThreadPoolScheduler-" + UUID.randomUUID().toString().substring(0, 8);

    public ThreadPoolScheduler(Plugin plugin, int poolSize) {
        super(plugin);
        for (int i = 0; i < poolSize; ++i) {
            this.threads.add(new ThreadPoolSchedulerThread(this, this.getName() + "-" + i));
        }
        new SchedulerThread(this.getName()).start();
    }

    @Override
    public synchronized Task run(Runnable runnable, Duration delay) {
        if (this.shouldStop) {
            throw new SchedulerClosedException(this);
        }
        FocessTask task = new FocessTask(runnable, this);
        this.tasks.add(new ComparableTask(System.currentTimeMillis() + delay.toMillis(), task));
        this.notify();
        return task;
    }

    @Override
    public synchronized Task runTimer(Runnable runnable, Duration delay, Duration period) {
        if (this.shouldStop) {
            throw new SchedulerClosedException(this);
        }
        FocessTask task = new FocessTask(runnable, period, this);
        this.tasks.add(new ComparableTask(System.currentTimeMillis() + delay.toMillis(), task));
        this.notify();
        return task;
    }

    @Override
    public synchronized <V> Callback<V> submit(Callable<V> callable, Duration delay) {
        if (this.shouldStop) {
            throw new SchedulerClosedException(this);
        }
        FocessCallback<V> callback = new FocessCallback<V>(callable, (Scheduler)this);
        this.tasks.add(new ComparableTask(System.currentTimeMillis() + delay.toMillis(), callback));
        this.notify();
        return callback;
    }

    @Override
    public void cancelAll() {
        this.tasks.clear();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized void close() {
        super.close();
        this.shouldStop = true;
        this.cancelAll();
        for (ThreadPoolSchedulerThread thread : this.threads) {
            thread.close();
        }
        this.notify();
    }

    @Override
    public boolean isClosed() {
        return this.shouldStop;
    }

    public void cancel(ITask task) {
        if (!this.taskThreadMap.containsKey(task)) {
            throw new TaskNotFoundException(task);
        }
        this.taskThreadMap.get(task).cancel();
        this.taskThreadMap.remove(task);
    }

    public void recreate(String name) {
        for (int i = 0; i < this.threads.size(); ++i) {
            if (!this.threads.get(i).getName().equals(name)) continue;
            this.threads.set(i, new ThreadPoolSchedulerThread(this, name));
            break;
        }
    }

    public void rerun(ITask task) {
        this.tasks.add(new ComparableTask(System.currentTimeMillis() + task.getPeriod().toMillis(), task));
    }

    public String toString() {
        return this.getName();
    }

    private class SchedulerThread
    extends Thread {
        public SchedulerThread(String name) {
            super(name);
        }

        private ThreadPoolSchedulerThread getAvailableThread() {
            for (int i = 1; i <= ThreadPoolScheduler.this.threads.size(); ++i) {
                int next = (ThreadPoolScheduler.this.currentThread + i) % ThreadPoolScheduler.this.threads.size();
                if (!((ThreadPoolSchedulerThread)ThreadPoolScheduler.this.threads.get(next)).isAvailable()) continue;
                ThreadPoolScheduler.this.currentThread = next;
                return (ThreadPoolSchedulerThread)ThreadPoolScheduler.this.threads.get(next);
            }
            ThreadPoolSchedulerThread thread = new ThreadPoolSchedulerThread(ThreadPoolScheduler.this, ThreadPoolScheduler.this.getName() + "-" + ThreadPoolScheduler.this.threads.size());
            ThreadPoolScheduler.this.threads.add(thread);
            return thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (!ThreadPoolScheduler.this.shouldStop) {
                        ThreadPoolScheduler threadPoolScheduler = ThreadPoolScheduler.this;
                        synchronized (threadPoolScheduler) {
                            if (ThreadPoolScheduler.this.tasks.isEmpty()) {
                                ThreadPoolScheduler.this.wait();
                            }
                        }
                        ComparableTask task = (ComparableTask)ThreadPoolScheduler.this.tasks.peek();
                        if (task != null) {
                            ITask iTask = task.getTask();
                            synchronized (iTask) {
                                if (task.isCancelled()) {
                                    ThreadPoolScheduler.this.tasks.poll();
                                    continue;
                                }
                                if (task.getTime() <= System.currentTimeMillis()) {
                                    ThreadPoolSchedulerThread thread = this.getAvailableThread();
                                    if (thread == null) {
                                        continue;
                                    }
                                    ThreadPoolScheduler.this.tasks.poll();
                                    ThreadPoolScheduler.this.taskThreadMap.put(task.getTask(), thread);
                                    thread.startTask(task.getTask());
                                }
                            }
                        }
                        SchedulerThread.sleep(0L);
                    }
                }
                catch (Exception e) {
                    FocessQQ.getLogger().thrLang("exception-thread-pool-scheduler", e, new Object[0]);
                    continue;
                }
                break;
            }
        }
    }
}

