/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq;

import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Scanner;
import java.util.concurrent.Future;
import java.util.zip.GZIPOutputStream;
import net.mamoe.mirai.contact.Friend;
import net.mamoe.mirai.contact.Group;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.focess.qq.api.bot.Bot;
import top.focess.qq.api.bot.BotManager;
import top.focess.qq.api.command.Command;
import top.focess.qq.api.command.CommandLine;
import top.focess.qq.api.command.CommandSender;
import top.focess.qq.api.command.DataCollection;
import top.focess.qq.api.command.DataConverter;
import top.focess.qq.api.command.converter.CommandDataConverter;
import top.focess.qq.api.command.converter.PluginDataConverter;
import top.focess.qq.api.command.data.BooleanBuffer;
import top.focess.qq.api.command.data.CommandBuffer;
import top.focess.qq.api.command.data.DoubleBuffer;
import top.focess.qq.api.command.data.IntBuffer;
import top.focess.qq.api.command.data.LongBuffer;
import top.focess.qq.api.command.data.PluginBuffer;
import top.focess.qq.api.command.data.StringBuffer;
import top.focess.qq.api.event.EventManager;
import top.focess.qq.api.event.ListenerHandler;
import top.focess.qq.api.event.chat.ConsoleChatEvent;
import top.focess.qq.api.event.server.ServerStartEvent;
import top.focess.qq.api.exceptions.BotLoginException;
import top.focess.qq.api.exceptions.EventSubmitException;
import top.focess.qq.api.exceptions.IllegalPortException;
import top.focess.qq.api.exceptions.PluginLoadException;
import top.focess.qq.api.net.ClientReceiver;
import top.focess.qq.api.net.ServerMultiReceiver;
import top.focess.qq.api.net.ServerReceiver;
import top.focess.qq.api.net.Socket;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.api.schedule.Scheduler;
import top.focess.qq.api.schedule.Schedulers;
import top.focess.qq.api.util.IOHandler;
import top.focess.qq.api.util.Pair;
import top.focess.qq.api.util.config.LangConfig;
import top.focess.qq.api.util.logger.FocessLogger;
import top.focess.qq.api.util.version.Version;
import top.focess.qq.core.bot.SimpleBotManager;
import top.focess.qq.core.commands.BotCommand;
import top.focess.qq.core.commands.CommandCommand;
import top.focess.qq.core.commands.DebugCommand;
import top.focess.qq.core.commands.FriendCommand;
import top.focess.qq.core.commands.GroupCommand;
import top.focess.qq.core.commands.LoadCommand;
import top.focess.qq.core.commands.PluginCommand;
import top.focess.qq.core.commands.ReloadCommand;
import top.focess.qq.core.commands.StopCommand;
import top.focess.qq.core.commands.UnloadCommand;
import top.focess.qq.core.listener.ChatListener;
import top.focess.qq.core.listener.ConsoleListener;
import top.focess.qq.core.listener.PluginListener;
import top.focess.qq.core.net.FocessClientReceiver;
import top.focess.qq.core.net.FocessReceiver;
import top.focess.qq.core.net.FocessSidedClientReceiver;
import top.focess.qq.core.net.FocessSidedClientSocket;
import top.focess.qq.core.net.FocessSidedReceiver;
import top.focess.qq.core.net.FocessSidedSocket;
import top.focess.qq.core.net.FocessSocket;
import top.focess.qq.core.net.FocessUDPMultiReceiver;
import top.focess.qq.core.net.FocessUDPReceiver;
import top.focess.qq.core.net.FocessUDPSocket;
import top.focess.qq.core.plugin.PluginClassLoader;
import top.focess.qq.core.util.option.Option;
import top.focess.qq.core.util.option.OptionParserClassifier;
import top.focess.qq.core.util.option.Options;
import top.focess.qq.core.util.option.type.IntegerOptionType;
import top.focess.qq.core.util.option.type.LongOptionType;
import top.focess.qq.core.util.option.type.OptionType;

public class FocessQQ {
    private static final Version VERSION;
    private static final FocessLogger LOGGER;
    @Deprecated
    private static final long AUTHOR_ID = 2624646185L;
    private static long administratorId;
    private static final MainPlugin MAIN_PLUGIN;
    private static final BotManager BOT_MANAGER;
    private static final Scheduler SCHEDULER;
    private static boolean running;
    @Nullable
    private static Socket socket;
    @Nullable
    private static Socket udpSocket;
    @Nullable
    private static ServerReceiver udpServerReceiver;
    @Nullable
    private static ServerReceiver serverReceiver;
    private static final LangConfig LANG_CONFIG;
    @Nullable
    private static ClientReceiver clientReceiver;
    @Nullable
    private static ServerMultiReceiver udpServerMultiReceiver;
    private static final Thread SHUTDOWN_HOOK;
    private static final Thread CONSOLE_INPUT_THREAD;
    private static Long username;
    private static String password;
    private static Bot bot;
    private static boolean saved;
    private static Options options;

    @Nullable
    public static Friend getFriend(long id) {
        return FocessQQ.getBot().getFriend(id);
    }

    @Nullable
    public static Group getGroup(long id) {
        return FocessQQ.getBot().getGroup(id);
    }

    public static boolean isRunning() {
        return running;
    }

    @NotNull
    public static FocessLogger getLogger() {
        return LOGGER;
    }

    @NotNull
    public static Bot getBot() {
        return bot;
    }

    public static long getUsername() {
        return username;
    }

    public static long getAdministratorId() {
        return administratorId;
    }

    @Deprecated
    public static long getAuthorId() {
        return 2624646185L;
    }

    public static BotManager getBotManager() {
        return BOT_MANAGER;
    }

    @Nullable
    public static Socket getSocket() {
        return socket;
    }

    @Nullable
    public static ServerReceiver getServerReceiver() {
        return serverReceiver;
    }

    @Nullable
    public static ClientReceiver getClientReceiver() {
        return clientReceiver;
    }

    @Nullable
    public static Socket getUdpSocket() {
        return udpSocket;
    }

    @Nullable
    public static ServerReceiver getUdpServerReceiver() {
        return udpServerReceiver;
    }

    @Nullable
    public static ServerMultiReceiver getUdpServerMultiReceiver() {
        return udpServerMultiReceiver;
    }

    public static Version getVersion() {
        return VERSION;
    }

    public static Plugin getMainPlugin() {
        return MAIN_PLUGIN;
    }

    public static List<Plugin> getPlugins() {
        return PluginClassLoader.getPlugins();
    }

    @Nullable
    public static Plugin getPlugin(String name) {
        return PluginClassLoader.getPlugin(name);
    }

    @Nullable
    public static Plugin getPlugin(Class<? extends Plugin> cls) {
        return PluginClassLoader.getPlugin(cls);
    }

    @Deprecated
    @NotNull
    public static Friend getAuthor() {
        return FocessQQ.getBot().getFriendOrFail(FocessQQ.getAuthorId());
    }

    @Nullable
    public static Friend getAdministrator() {
        return FocessQQ.getBot().getFriend(FocessQQ.getAdministratorId());
    }

    private static void requestAccountInformation() {
        try {
            IOHandler.getConsoleIoHandler().outputLang("input-account-username", new Object[0]);
            String str = IOHandler.getConsoleIoHandler().input();
            if (str.equals("stop")) {
                FocessQQ.getLogger().debugLang("save-log", new Object[0]);
                FocessQQ.saveLogFile();
                System.exit(0);
            }
            username = Long.parseLong(str);
            IOHandler.getConsoleIoHandler().outputLang("input-account-password", new Object[0]);
            password = IOHandler.getConsoleIoHandler().input();
        }
        catch (Exception e) {
            FocessQQ.requestAccountInformation();
        }
    }

    public static void main(String[] args) {
        FocessSocket focessSocket;
        Thread.currentThread().setUncaughtExceptionHandler((t, e) -> {
            FocessQQ.getLogger().thrLang("exception-uncaught-exception", e, new Object[0]);
            FocessQQ.getLogger().fatalLang("fatal-uncaught-exception", new Object[0]);
            FocessQQ.exit();
        });
        try {
            FocessQQ.getLogger().debugLang("setup-uncaught-exception-handler", new Object[0]);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        SCHEDULER.runTimer(() -> {
            while (!ConsoleListener.QUESTS.isEmpty() && System.currentTimeMillis() - ConsoleListener.QUESTS.peek().getValue() > 300000L) {
                ConsoleListener.QUESTS.poll().getKey().input(null);
            }
            for (CommandSender sender : ChatListener.QUESTS.keySet()) {
                Queue<Pair<IOHandler, Pair<Boolean, Long>>> queue = ChatListener.QUESTS.get(sender);
                while (!queue.isEmpty() && System.currentTimeMillis() - queue.peek().getValue().getValue() > 300000L) {
                    queue.poll().getKey().input(null);
                }
            }
        }, Duration.ZERO, Duration.ofMinutes(1L));
        CONSOLE_INPUT_THREAD.start();
        FocessQQ.getLogger().debugLang("start-console-input-thread", new Object[0]);
        options = Options.parse(args, new OptionParserClassifier("help", new OptionType[0]), new OptionParserClassifier("user", LongOptionType.LONG_OPTION_TYPE, OptionType.DEFAULT_OPTION_TYPE), new OptionParserClassifier("server", IntegerOptionType.INTEGER_OPTION_TYPE), new OptionParserClassifier("client", OptionType.DEFAULT_OPTION_TYPE, IntegerOptionType.INTEGER_OPTION_TYPE, OptionType.DEFAULT_OPTION_TYPE, IntegerOptionType.INTEGER_OPTION_TYPE, OptionType.DEFAULT_OPTION_TYPE), new OptionParserClassifier("sided", new OptionType[0]), new OptionParserClassifier("client", OptionType.DEFAULT_OPTION_TYPE, IntegerOptionType.INTEGER_OPTION_TYPE, OptionType.DEFAULT_OPTION_TYPE), new OptionParserClassifier("udp", IntegerOptionType.INTEGER_OPTION_TYPE), new OptionParserClassifier("multi", new OptionType[0]), new OptionParserClassifier("admin", LongOptionType.LONG_OPTION_TYPE), new OptionParserClassifier("noDefaultPluginLoad", new OptionType[0]));
        Option option = options.get("help");
        if (option != null) {
            FocessQQ.getLogger().info("--help");
            FocessQQ.getLogger().info("--user <id> <password>");
            FocessQQ.getLogger().info("--admin <id>");
            FocessQQ.getLogger().info("--server <port>");
            FocessQQ.getLogger().info("--client <localhost> <localport> <host> <port> <name>");
            FocessQQ.getLogger().info("--client <host> <port> <name>");
            FocessQQ.getLogger().info("--udp <port>");
            FocessQQ.getLogger().info("--sided");
            FocessQQ.getLogger().info("--multi");
            FocessQQ.saveLogFile();
            FocessQQ.getLogger().debugLang("save-log", new Object[0]);
            return;
        }
        FocessQQ.getLogger().infoLang("start-main", FocessQQ.getVersion());
        option = options.get("user");
        if (option != null) {
            username = option.get(LongOptionType.LONG_OPTION_TYPE);
            password = option.get(OptionType.DEFAULT_OPTION_TYPE);
            FocessQQ.getLogger().debugLang("use-given-account", new Object[0]);
        }
        if ((option = options.get("admin")) != null) {
            administratorId = option.get(LongOptionType.LONG_OPTION_TYPE);
        }
        Option sidedOption = options.get("sided");
        Option multiOption = options.get("multi");
        option = options.get("server");
        if (option != null) {
            if (sidedOption == null) {
                try {
                    focessSocket = new FocessSocket(option.get(IntegerOptionType.INTEGER_OPTION_TYPE));
                    serverReceiver = new FocessReceiver(focessSocket);
                    focessSocket.registerReceiver(serverReceiver);
                    socket = focessSocket;
                    FocessQQ.getLogger().infoLang("create-focess-socket-server", new Object[0]);
                }
                catch (Exception e3) {
                    FocessQQ.getLogger().thrLang("exception-create-focess-socket-server", e3, new Object[0]);
                }
            } else {
                try {
                    FocessSidedSocket focessSidedSocket = new FocessSidedSocket(option.get(IntegerOptionType.INTEGER_OPTION_TYPE));
                    serverReceiver = new FocessSidedReceiver();
                    focessSidedSocket.registerReceiver(serverReceiver);
                    socket = focessSidedSocket;
                    FocessQQ.getLogger().infoLang("create-focess-sided-socket-server", new Object[0]);
                }
                catch (Exception e4) {
                    FocessQQ.getLogger().thrLang("exception-create-focess-sided-socket-server", e4, new Object[0]);
                }
            }
        }
        if ((option = options.get("client")) != null) {
            if (sidedOption == null) {
                try {
                    focessSocket = new FocessSocket(option.get(IntegerOptionType.INTEGER_OPTION_TYPE));
                    String localhost = option.get(OptionType.DEFAULT_OPTION_TYPE);
                    String host = option.get(OptionType.DEFAULT_OPTION_TYPE);
                    int port = option.get(IntegerOptionType.INTEGER_OPTION_TYPE);
                    String name = option.get(OptionType.DEFAULT_OPTION_TYPE);
                    clientReceiver = new FocessClientReceiver(focessSocket, localhost, host, port, name);
                    focessSocket.registerReceiver(clientReceiver);
                    socket = focessSocket;
                    FocessQQ.getLogger().infoLang("create-focess-socket-client", new Object[0]);
                }
                catch (Exception e5) {
                    FocessQQ.getLogger().thrLang("exception-create-focess-socket-client", e5, new Object[0]);
                }
            } else {
                try {
                    String host = option.get(OptionType.DEFAULT_OPTION_TYPE);
                    int port = option.get(IntegerOptionType.INTEGER_OPTION_TYPE);
                    String name = option.get(OptionType.DEFAULT_OPTION_TYPE);
                    FocessSidedClientSocket focessSidedClientSocket = new FocessSidedClientSocket(host, port);
                    clientReceiver = new FocessSidedClientReceiver(focessSidedClientSocket, name);
                    focessSidedClientSocket.registerReceiver(clientReceiver);
                    socket = focessSidedClientSocket;
                    FocessQQ.getLogger().infoLang("create-focess-sided-socket-client", new Object[0]);
                }
                catch (Exception e6) {
                    FocessQQ.getLogger().thrLang("exception-create-focess-sided-socket-client", e6, new Object[0]);
                }
            }
        }
        if ((option = options.get("udp")) != null) {
            try {
                FocessUDPSocket focessUDPSocket = new FocessUDPSocket(option.get(IntegerOptionType.INTEGER_OPTION_TYPE));
                if (multiOption == null) {
                    udpServerReceiver = new FocessUDPReceiver(focessUDPSocket);
                    focessUDPSocket.registerReceiver(udpServerReceiver);
                } else {
                    udpServerMultiReceiver = new FocessUDPMultiReceiver(focessUDPSocket);
                    focessUDPSocket.registerReceiver(udpServerMultiReceiver);
                }
                udpSocket = focessUDPSocket;
                FocessQQ.getLogger().infoLang("create-focess-udp-socket-client", new Object[0]);
            }
            catch (IllegalPortException e7) {
                FocessQQ.getLogger().thrLang("exception-create-focess-udp-socket-client", e7, new Object[0]);
            }
        }
        try {
            PluginClassLoader.enablePlugin(MAIN_PLUGIN);
            FocessQQ.getLogger().debugLang("load-main-plugin", new Object[0]);
        }
        catch (Exception e8) {
            if (e8 instanceof PluginLoadException && e8.getCause() != null && e8.getCause() instanceof BotLoginException) {
                FocessQQ.getLogger().fatalLang("fatal-default-bot-login-failed", FocessQQ.getUsername());
                FocessQQ.getLogger().thrLang("exception-default-bot-login-failed", e8.getCause(), new Object[0]);
            } else {
                FocessQQ.getLogger().thrLang("exception-load-main-plugin", e8, new Object[0]);
            }
            FocessQQ.exit();
        }
    }

    public static void exit() {
        SCHEDULER.run(() -> {
            FocessQQ.getLogger().fatalLang("fatal-exit-failed", new Object[0]);
            Runtime.getRuntime().removeShutdownHook(SHUTDOWN_HOOK);
            System.exit(0);
        }, Duration.ofSeconds(5L));
        if (MAIN_PLUGIN.isEnabled()) {
            PluginClassLoader.disablePlugin(MAIN_PLUGIN);
        }
    }

    private static void saveLogFile() {
        try {
            File latest = new File("logs", "latest.log");
            if (latest.exists()) {
                int len;
                String name = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date());
                File target = new File("logs", name + ".log");
                Files.copy((File)latest, (File)target);
                GZIPOutputStream gzipOutputStream = new GZIPOutputStream(new FileOutputStream(new File("logs", name + ".gz")));
                FileInputStream inputStream = new FileInputStream(target);
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) > 0) {
                    gzipOutputStream.write(buf, 0, len);
                }
                inputStream.close();
                gzipOutputStream.finish();
                gzipOutputStream.close();
                if (!target.delete()) {
                    FocessQQ.getLogger().fatalLang("fatal-delete-log-file-failed", target.getName());
                }
            }
        }
        catch (IOException e) {
            FocessQQ.getLogger().thrLang("exception-save-log", e, new Object[0]);
        }
    }

    public static LangConfig getLangConfig() {
        return LANG_CONFIG;
    }

    static {
        Version version;
        Properties properties = new Properties();
        try {
            properties.load(FocessQQ.class.getResourceAsStream("/default.properties"));
            version = new Version(properties.getProperty("version"));
        }
        catch (Exception e) {
            version = new Version("build");
        }
        VERSION = version;
        LOGGER = new FocessLogger();
        administratorId = 0L;
        MAIN_PLUGIN = new MainPlugin();
        BOT_MANAGER = new SimpleBotManager();
        SCHEDULER = Schedulers.newFocessScheduler(MAIN_PLUGIN);
        running = false;
        LANG_CONFIG = new LangConfig(FocessQQ.class.getResourceAsStream("/lang.yml"));
        SHUTDOWN_HOOK = new Thread("SavingData"){

            @Override
            public void run() {
                if (running) {
                    FocessQQ.getLogger().fatalLang("fatal-save-data", new Object[0]);
                    FocessQQ.getLogger().debugLang("save-log", new Object[0]);
                    FocessQQ.saveLogFile();
                    saved = true;
                    PluginClassLoader.disablePlugin(MAIN_PLUGIN);
                }
            }
        };
        CONSOLE_INPUT_THREAD = new Thread(() -> {
            Scanner scanner = new Scanner(System.in);
            while (scanner.hasNextLine()) {
                String input = scanner.nextLine();
                try {
                    EventManager.submit(new ConsoleChatEvent(input));
                }
                catch (EventSubmitException e) {
                    FocessQQ.getLogger().thrLang("exception-submit-console-chat-event", e, new Object[0]);
                }
            }
        });
        saved = false;
    }

    public static final class MainPlugin
    extends Plugin {
        private static Map<String, Object> properties;

        public MainPlugin() {
            super("MainPlugin", "MidCoard", FocessQQ.getVersion());
            if (running) {
                FocessQQ.getLogger().fatalLang("fatal-main-plugin-already-running", new Object[0]);
                FocessQQ.exit();
            }
            try {
                Field field = Plugin.class.getDeclaredField("langConfig");
                field.setAccessible(true);
                field.set(this, LANG_CONFIG);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public static Map<String, Object> getProperties() {
            return properties;
        }

        @Override
        public void enable() {
            FocessQQ.getLogger().debugLang("start-enable-main-plugin", new Object[0]);
            running = true;
            this.registerListener(new ConsoleListener());
            this.registerListener(new ChatListener());
            this.registerListener(new PluginListener());
            FocessQQ.getLogger().debugLang("register-default-listeners", new Object[0]);
            if (username == null || password == null) {
                FocessQQ.requestAccountInformation();
                FocessQQ.getLogger().debugLang("request-account-information", new Object[0]);
            }
            this.registerBuffer(DataConverter.DEFAULT_DATA_CONVERTER, StringBuffer::allocate);
            this.registerBuffer(DataConverter.INTEGER_DATA_CONVERTER, IntBuffer::allocate);
            this.registerBuffer(PluginDataConverter.PLUGIN_DATA_CONVERTER, PluginBuffer::allocate);
            this.registerBuffer(CommandDataConverter.COMMAND_DATA_CONVERTER, CommandBuffer::allocate);
            this.registerBuffer(DataConverter.LONG_DATA_CONVERTER, LongBuffer::allocate);
            this.registerBuffer(DataConverter.DOUBLE_DATA_CONVERTER, DoubleBuffer::allocate);
            this.registerBuffer(DataConverter.BOOLEAN_DATA_CONVERTER, BooleanBuffer::allocate);
            FocessQQ.getLogger().debugLang("register-default-buffers", new Object[0]);
            properties = this.getDefaultConfig().getValues();
            if (properties == null) {
                properties = Maps.newHashMap();
            }
            FocessQQ.getLogger().debugLang("load-default-properties", new Object[0]);
            this.registerCommand(new LoadCommand());
            this.registerCommand(new UnloadCommand());
            this.registerCommand(new StopCommand());
            this.registerCommand(new FriendCommand());
            this.registerCommand(new GroupCommand());
            this.registerCommand(new BotCommand());
            this.registerCommand(new ReloadCommand());
            this.registerCommand(new CommandCommand());
            this.registerCommand(new PluginCommand());
            this.registerCommand(new DebugCommand());
            FocessQQ.getLogger().debugLang("register-default-commands", new Object[0]);
            bot = FocessQQ.getBotManager().loginDirectly(username, password);
            FocessQQ.getLogger().debugLang("login-default-bot", new Object[0]);
            File plugins = new File("plugins");
            if (plugins.exists() && options.get("noDefaultPluginLoad") == null) {
                for (File file2 : plugins.listFiles(file -> file.getName().endsWith(".jar"))) {
                    try {
                        Future<Boolean> future = CommandLine.exec("load plugins/" + file2.getName());
                        future.get();
                    }
                    catch (Exception e) {
                        FocessQQ.getLogger().thrLang("exception-load-default-plugin", e, new Object[0]);
                    }
                }
            }
            FocessQQ.getLogger().debugLang("load-default-plugins", new Object[0]);
            Runtime.getRuntime().addShutdownHook(SHUTDOWN_HOOK);
            FocessQQ.getLogger().debugLang("setup-shutdown-hook", new Object[0]);
            try {
                EventManager.submit(new ServerStartEvent());
            }
            catch (EventSubmitException e) {
                FocessQQ.getLogger().thrLang("exception-submit-server-start-event", e, new Object[0]);
            }
        }

        @Override
        public void disable() {
            FocessQQ.getLogger().debugLang("start-disable-main-plugin", new Object[0]);
            for (Plugin plugin : FocessQQ.getPlugins()) {
                if (plugin.equals(this)) continue;
                try {
                    PluginClassLoader.disablePlugin(plugin);
                }
                catch (Exception e) {
                    FocessQQ.getLogger().thrLang("exception-unload-default-plugin", e, new Object[0]);
                }
            }
            FocessQQ.getLogger().debugLang("unload-all-plugins-except-main-plugin", new Object[0]);
            if (Command.unregisterAll()) {
                FocessQQ.getLogger().debugLang("commands-not-empty", new Object[0]);
            }
            FocessQQ.getLogger().debugLang("unregister-all-commands", new Object[0]);
            if (ListenerHandler.unregisterAll()) {
                FocessQQ.getLogger().debugLang("listeners-not-empty", new Object[0]);
            }
            FocessQQ.getLogger().debugLang("unregister-all-listeners", new Object[0]);
            if (DataCollection.unregisterAll()) {
                FocessQQ.getLogger().debugLang("buffers-not-empty", new Object[0]);
            }
            FocessQQ.getLogger().debugLang("unregister-all-buffers", new Object[0]);
            if (bot != null) {
                SimpleBotManager.removeAll();
                FocessQQ.getLogger().debugLang("remove-all-bots", new Object[0]);
            }
            for (String key : properties.keySet()) {
                this.getDefaultConfig().set(key, properties.get(key));
            }
            this.getDefaultConfig().save();
            FocessQQ.getLogger().debugLang("save-default-properties", new Object[0]);
            if (FocessQQ.getSocket() != null && FocessQQ.getSocket().close()) {
                FocessQQ.getLogger().debugLang("socket-packet-handler-not-empty", new Object[0]);
            }
            if (FocessQQ.getUdpSocket() != null && FocessQQ.getUdpSocket().close()) {
                FocessQQ.getLogger().debugLang("udp-socket-packet-handler-not-empty", new Object[0]);
            }
            FocessQQ.getLogger().debugLang("close-all-sockets", new Object[0]);
            if (!saved) {
                FocessQQ.getLogger().debugLang("save-log", new Object[0]);
                FocessQQ.saveLogFile();
            }
            running = false;
            if (Schedulers.closeAll()) {
                FocessQQ.getLogger().debugLang("schedulers-not-empty", new Object[0]);
            }
            FocessQQ.getLogger().debugLang("unregister-all-schedulers", new Object[0]);
            if (!saved) {
                saved = true;
                System.exit(0);
            }
        }
    }
}

