/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.command.data;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import top.focess.qq.api.command.data.DataBuffer;

public class ObjectBuffer
extends DataBuffer<Object> {
    private final Object[] objects;
    private int pos;
    private int limit;

    private ObjectBuffer(int size) {
        this.objects = new Object[size];
        this.pos = 0;
        this.limit = size;
    }

    public static ObjectBuffer allocate(int size) {
        return new ObjectBuffer(size);
    }

    @Override
    public void flip() {
        this.limit = this.pos;
        this.pos = 0;
    }

    @Override
    public void put(Object o) {
        if (this.pos == this.limit) {
            throw new BufferOverflowException();
        }
        this.objects[this.pos++] = o;
    }

    @Override
    public Object get() {
        if (this.pos == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.objects[this.pos++];
    }

    @Override
    public Object get(int index) {
        return this.objects[index];
    }
}

