/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.bot;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.imageio.stream.FileImageOutputStream;
import kotlin.coroutines.Continuation;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.BotFactory;
import net.mamoe.mirai.contact.Member;
import net.mamoe.mirai.event.Listener;
import net.mamoe.mirai.event.events.BotInvitedJoinGroupRequestEvent;
import net.mamoe.mirai.event.events.FriendInputStatusChangedEvent;
import net.mamoe.mirai.event.events.FriendMessageEvent;
import net.mamoe.mirai.event.events.GroupMessageEvent;
import net.mamoe.mirai.event.events.MessageRecallEvent;
import net.mamoe.mirai.event.events.NewFriendRequestEvent;
import net.mamoe.mirai.event.events.StrangerMessageEvent;
import net.mamoe.mirai.utils.BotConfiguration;
import net.mamoe.mirai.utils.LoginSolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.bot.BotManager;
import top.focess.qq.api.event.EventManager;
import top.focess.qq.api.event.bot.BotLoginEvent;
import top.focess.qq.api.event.bot.BotLogoutEvent;
import top.focess.qq.api.event.bot.BotReloginEvent;
import top.focess.qq.api.event.bot.FriendInputStatusEvent;
import top.focess.qq.api.event.chat.FriendChatEvent;
import top.focess.qq.api.event.chat.GroupChatEvent;
import top.focess.qq.api.event.chat.StrangerChatEvent;
import top.focess.qq.api.event.recall.FriendRecallEvent;
import top.focess.qq.api.event.recall.GroupRecallEvent;
import top.focess.qq.api.event.request.FriendRequestEvent;
import top.focess.qq.api.event.request.GroupRequestEvent;
import top.focess.qq.api.exceptions.BotLoginException;
import top.focess.qq.api.exceptions.EventSubmitException;
import top.focess.qq.api.schedule.Scheduler;
import top.focess.qq.api.schedule.Schedulers;
import top.focess.qq.api.util.IOHandler;
import top.focess.qq.core.bot.SimpleBot;

public class SimpleBotManager
implements BotManager {
    private static final Scheduler SCHEDULER = Schedulers.newFocessScheduler(FocessQQ.getMainPlugin(), "BotManager");
    private static final Map<top.focess.qq.api.bot.Bot, List<Listener<?>>> BOT_LISTENER_MAP = Maps.newHashMap();
    private static final Map<Long, top.focess.qq.api.bot.Bot> BOTS = Maps.newConcurrentMap();

    public SimpleBotManager() {
        if (FocessQQ.getBotManager() != null) {
            FocessQQ.getLogger().fatalLang("fatal-simple-bot-manager-already-exist", new Object[0]);
            FocessQQ.exit();
        }
    }

    @Override
    @NotNull
    public Future<top.focess.qq.api.bot.Bot> login(long id, String password) {
        return SCHEDULER.submit(() -> this.loginDirectly(id, password));
    }

    @Override
    @NotNull
    public top.focess.qq.api.bot.Bot loginDirectly(long id, String password) {
        Bot bot;
        BotConfiguration configuration = BotConfiguration.getDefault();
        configuration.setProtocol(BotConfiguration.MiraiProtocol.ANDROID_PAD);
        File cache = new File("devices/" + id + "/cache");
        if (!cache.exists() && !cache.mkdirs()) {
            throw new BotLoginException(id, FocessQQ.getLangConfig().get("fatal-create-cache-dir-failed"));
        }
        configuration.fileBasedDeviceInfo("devices/" + id + "/device.json");
        configuration.setCacheDir(cache);
        configuration.setLoginSolver(new LoginSolver(){

            @Nullable
            public Object onSolvePicCaptcha(@NotNull Bot bot, @NotNull byte[] bytes, @NotNull Continuation<? super String> continuation) {
                try {
                    FileImageOutputStream outputStream = new FileImageOutputStream(new File("captcha.jpg"));
                    outputStream.write(bytes);
                    outputStream.close();
                }
                catch (IOException e) {
                    FocessQQ.getLogger().thrLang("exception-load-captcha-picture", e, new Object[0]);
                }
                FocessQQ.getLogger().infoLang("input-captcha-code", new Object[0]);
                return IOHandler.getConsoleIoHandler().input();
            }

            @Nullable
            public Object onSolveSliderCaptcha(@NotNull Bot bot, @NotNull String s, @NotNull Continuation<? super String> continuation) {
                FocessQQ.getLogger().info(s);
                IOHandler.getConsoleIoHandler().input();
                return null;
            }

            @Nullable
            public Object onSolveUnsafeDeviceLoginVerify(@NotNull Bot bot, @NotNull String s, @NotNull Continuation<? super String> continuation) {
                FocessQQ.getLogger().info(s);
                IOHandler.getConsoleIoHandler().input();
                return null;
            }
        });
        try {
            bot = BotFactory.INSTANCE.newBot(id, password, configuration);
            bot.login();
        }
        catch (Exception e) {
            throw new BotLoginException(id, e);
        }
        SimpleBot b = new SimpleBot(id, password, bot);
        try {
            EventManager.submit(new BotLoginEvent(b));
        }
        catch (EventSubmitException e) {
            FocessQQ.getLogger().thrLang("exception-submit-bot-login-event", e, new Object[0]);
        }
        ArrayList listeners = Lists.newArrayList();
        listeners.add(bot.getEventChannel().subscribeAlways(GroupMessageEvent.class, event -> {
            GroupChatEvent e = new GroupChatEvent(b, event.getSender(), event.getMessage(), event.getSource());
            try {
                EventManager.submit(e);
            }
            catch (EventSubmitException eventSubmitException) {
                FocessQQ.getLogger().thrLang("exception-submit-group-chat-event", eventSubmitException, new Object[0]);
            }
        }));
        listeners.add(bot.getEventChannel().subscribeAlways(FriendMessageEvent.class, event -> {
            FriendChatEvent e = new FriendChatEvent(b, event.getFriend(), event.getMessage(), event.getSource());
            try {
                EventManager.submit(e);
            }
            catch (EventSubmitException eventSubmitException) {
                FocessQQ.getLogger().thrLang("exception-submit-friend-chat-event", eventSubmitException, new Object[0]);
            }
        }));
        listeners.add(bot.getEventChannel().subscribeAlways(MessageRecallEvent.GroupRecall.class, event -> {
            GroupRecallEvent e = new GroupRecallEvent(b, (Member)event.getAuthor(), event.getMessageIds(), event.getOperator());
            try {
                EventManager.submit(e);
            }
            catch (EventSubmitException ex) {
                FocessQQ.getLogger().thrLang("exception-submit-group-recall-event", ex, new Object[0]);
            }
        }));
        listeners.add(bot.getEventChannel().subscribeAlways(MessageRecallEvent.FriendRecall.class, event -> {
            FriendRecallEvent e = new FriendRecallEvent(b, event.getAuthor(), event.getMessageIds());
            try {
                EventManager.submit(e);
            }
            catch (EventSubmitException ex) {
                FocessQQ.getLogger().thrLang("exception-submit-friend-recall-event", ex, new Object[0]);
            }
        }));
        listeners.add(bot.getEventChannel().subscribeAlways(NewFriendRequestEvent.class, event -> {
            FriendRequestEvent e = new FriendRequestEvent(b, event.getFromId(), event.getFromNick(), event.getFromGroup(), event.getMessage());
            try {
                EventManager.submit(e);
            }
            catch (EventSubmitException ex) {
                FocessQQ.getLogger().thrLang("exception-submit-friend-request-event", ex, new Object[0]);
            }
            if (e.getAccept() != null) {
                if (e.getAccept().booleanValue()) {
                    event.accept();
                } else {
                    event.reject(e.isBlackList());
                }
            }
        }));
        listeners.add(bot.getEventChannel().subscribeAlways(BotInvitedJoinGroupRequestEvent.class, event -> {
            GroupRequestEvent e = new GroupRequestEvent(b, event.getGroupId(), event.getGroupName(), event.getInvitor());
            try {
                EventManager.submit(e);
            }
            catch (EventSubmitException ex) {
                FocessQQ.getLogger().thrLang("exception-submit-group-request-event", ex, new Object[0]);
            }
            if (e.getAccept() != null) {
                if (e.getAccept().booleanValue()) {
                    event.accept();
                } else {
                    event.ignore();
                }
            }
        }));
        listeners.add(bot.getEventChannel().subscribeAlways(FriendInputStatusChangedEvent.class, event -> {
            FriendInputStatusEvent e = new FriendInputStatusEvent(b, event.getFriend(), event.getInputting());
            try {
                EventManager.submit(e);
            }
            catch (EventSubmitException ex) {
                FocessQQ.getLogger().thrLang("exception-submit-friend-input-status-event", ex, new Object[0]);
            }
        }));
        listeners.add(bot.getEventChannel().subscribeAlways(StrangerMessageEvent.class, event -> {
            StrangerChatEvent e = new StrangerChatEvent(b, event.getMessage(), event.getSender(), event.getSource());
            try {
                EventManager.submit(e);
            }
            catch (EventSubmitException ex) {
                FocessQQ.getLogger().thrLang("exception-submit-stranger-chat-event", ex, new Object[0]);
            }
        }));
        BOT_LISTENER_MAP.put(b, listeners);
        BOTS.put(id, b);
        return b;
    }

    @Override
    public boolean login(top.focess.qq.api.bot.Bot b) {
        if (!b.isOnline() && b instanceof SimpleBot) {
            Bot bot;
            long id = b.getId();
            BotConfiguration configuration = BotConfiguration.getDefault();
            configuration.setProtocol(BotConfiguration.MiraiProtocol.ANDROID_PAD);
            File cache = new File("devices/" + id + "/cache");
            if (!cache.exists() && !cache.mkdirs()) {
                throw new BotLoginException(id, FocessQQ.getLangConfig().get("fatal-create-cache-dir-failed"));
            }
            configuration.fileBasedDeviceInfo("devices/" + id + "/device.json");
            configuration.setCacheDir(cache);
            configuration.setLoginSolver(new LoginSolver(){

                @Nullable
                public Object onSolvePicCaptcha(@NotNull Bot bot, @NotNull byte[] bytes, @NotNull Continuation<? super String> continuation) {
                    try {
                        FileImageOutputStream outputStream = new FileImageOutputStream(new File("captcha.jpg"));
                        outputStream.write(bytes);
                        outputStream.close();
                    }
                    catch (IOException e) {
                        FocessQQ.getLogger().thrLang("exception-load-captcha-picture", e, new Object[0]);
                    }
                    FocessQQ.getLogger().infoLang("input-captcha-code", new Object[0]);
                    return IOHandler.getConsoleIoHandler().input();
                }

                @Nullable
                public Object onSolveSliderCaptcha(@NotNull Bot bot, @NotNull String s, @NotNull Continuation<? super String> continuation) {
                    FocessQQ.getLogger().info(s);
                    IOHandler.getConsoleIoHandler().input();
                    return null;
                }

                @Nullable
                public Object onSolveUnsafeDeviceLoginVerify(@NotNull Bot bot, @NotNull String s, @NotNull Continuation<? super String> continuation) {
                    FocessQQ.getLogger().info(s);
                    IOHandler.getConsoleIoHandler().input();
                    return null;
                }
            });
            try {
                bot = BotFactory.INSTANCE.newBot(id, ((SimpleBot)b).getPassword(), configuration);
                bot.login();
                ((SimpleBot)b).setNativeBot(bot);
            }
            catch (Exception e) {
                throw new BotLoginException(id, e);
            }
            try {
                EventManager.submit(new BotLoginEvent(b));
            }
            catch (EventSubmitException e) {
                FocessQQ.getLogger().thrLang("exception-submit-bot-login-event", e, new Object[0]);
            }
            ArrayList listeners = Lists.newArrayList();
            listeners.add(bot.getEventChannel().subscribeAlways(GroupMessageEvent.class, event -> {
                GroupChatEvent e = new GroupChatEvent(b, event.getSender(), event.getMessage(), event.getSource());
                try {
                    EventManager.submit(e);
                }
                catch (EventSubmitException eventSubmitException) {
                    FocessQQ.getLogger().thrLang("exception-submit-group-chat-event", eventSubmitException, new Object[0]);
                }
            }));
            listeners.add(bot.getEventChannel().subscribeAlways(FriendMessageEvent.class, event -> {
                FriendChatEvent e = new FriendChatEvent(b, event.getFriend(), event.getMessage(), event.getSource());
                try {
                    EventManager.submit(e);
                }
                catch (EventSubmitException eventSubmitException) {
                    FocessQQ.getLogger().thrLang("exception-submit-friend-chat-event", eventSubmitException, new Object[0]);
                }
            }));
            listeners.add(bot.getEventChannel().subscribeAlways(MessageRecallEvent.GroupRecall.class, event -> {
                GroupRecallEvent e = new GroupRecallEvent(b, (Member)event.getAuthor(), event.getMessageIds(), event.getOperator());
                try {
                    EventManager.submit(e);
                }
                catch (EventSubmitException ex) {
                    FocessQQ.getLogger().thrLang("exception-submit-group-recall-event", ex, new Object[0]);
                }
            }));
            listeners.add(bot.getEventChannel().subscribeAlways(MessageRecallEvent.FriendRecall.class, event -> {
                FriendRecallEvent e = new FriendRecallEvent(b, event.getAuthor(), event.getMessageIds());
                try {
                    EventManager.submit(e);
                }
                catch (EventSubmitException ex) {
                    FocessQQ.getLogger().thrLang("exception-submit-friend-recall-event", ex, new Object[0]);
                }
            }));
            listeners.add(bot.getEventChannel().subscribeAlways(NewFriendRequestEvent.class, event -> {
                FriendRequestEvent e = new FriendRequestEvent(b, event.getFromId(), event.getFromNick(), event.getFromGroup(), event.getMessage());
                try {
                    EventManager.submit(e);
                }
                catch (EventSubmitException ex) {
                    FocessQQ.getLogger().thrLang("exception-submit-friend-request-event", ex, new Object[0]);
                }
                if (e.getAccept() != null) {
                    if (e.getAccept().booleanValue()) {
                        event.accept();
                    } else {
                        event.reject(e.isBlackList());
                    }
                }
            }));
            listeners.add(bot.getEventChannel().subscribeAlways(BotInvitedJoinGroupRequestEvent.class, event -> {
                GroupRequestEvent e = new GroupRequestEvent(b, event.getGroupId(), event.getGroupName(), event.getInvitor());
                try {
                    EventManager.submit(e);
                }
                catch (EventSubmitException ex) {
                    FocessQQ.getLogger().thrLang("exception-submit-group-request-event", ex, new Object[0]);
                }
                if (e.getAccept() != null) {
                    if (e.getAccept().booleanValue()) {
                        event.accept();
                    } else {
                        event.ignore();
                    }
                }
            }));
            listeners.add(bot.getEventChannel().subscribeAlways(FriendInputStatusChangedEvent.class, event -> {
                FriendInputStatusEvent e = new FriendInputStatusEvent(b, event.getFriend(), event.getInputting());
                try {
                    EventManager.submit(e);
                }
                catch (EventSubmitException ex) {
                    FocessQQ.getLogger().thrLang("exception-submit-friend-input-status-event", ex, new Object[0]);
                }
            }));
            listeners.add(bot.getEventChannel().subscribeAlways(StrangerMessageEvent.class, event -> {
                StrangerChatEvent e = new StrangerChatEvent(b, event.getMessage(), event.getSender(), event.getSource());
                try {
                    EventManager.submit(e);
                }
                catch (EventSubmitException ex) {
                    FocessQQ.getLogger().thrLang("exception-submit-stranger-chat-event", ex, new Object[0]);
                }
            }));
            BOT_LISTENER_MAP.put(b, listeners);
            return true;
        }
        return false;
    }

    @Override
    public boolean logout(@NotNull top.focess.qq.api.bot.Bot bot) {
        if (!bot.isOnline()) {
            return false;
        }
        bot.getNativeBot().close();
        for (Listener listener : (List)BOT_LISTENER_MAP.getOrDefault(bot, Lists.newArrayList())) {
            listener.complete();
        }
        BOT_LISTENER_MAP.remove(bot);
        try {
            EventManager.submit(new BotLogoutEvent(bot));
        }
        catch (EventSubmitException e) {
            FocessQQ.getLogger().thrLang("exception-submit-bot-logout-event", e, new Object[0]);
        }
        return true;
    }

    @Override
    @Nullable
    public top.focess.qq.api.bot.Bot getBot(long username) {
        return BOTS.get(username);
    }

    @Override
    public boolean relogin(@NotNull top.focess.qq.api.bot.Bot bot) {
        boolean ret = this.logout(bot) & this.login(bot);
        try {
            EventManager.submit(new BotReloginEvent(bot));
        }
        catch (EventSubmitException e) {
            FocessQQ.getLogger().thrLang("exception-submit-bot-relogin-event", e, new Object[0]);
        }
        return ret;
    }

    @Override
    public List<top.focess.qq.api.bot.Bot> getBots() {
        return Lists.newArrayList(BOTS.values());
    }

    @Override
    public top.focess.qq.api.bot.Bot remove(long id) {
        if (FocessQQ.getBot().getId() == id) {
            return null;
        }
        top.focess.qq.api.bot.Bot b = BOTS.remove(id);
        if (b != null) {
            b.logout();
        }
        return b;
    }

    public static void removeAll() {
        for (Long id : BOTS.keySet()) {
            FocessQQ.getBotManager().remove(id);
        }
        top.focess.qq.api.bot.Bot b = BOTS.remove(FocessQQ.getBot().getId());
        if (b != null) {
            b.logout();
        }
    }
}

