/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.net;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import top.focess.qq.api.net.Receiver;
import top.focess.qq.api.net.Socket;
import top.focess.qq.api.net.packet.Packet;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.api.util.Pair;
import top.focess.qq.core.net.PacketHandler;

public abstract class ASocket
implements Socket {
    protected final Map<Class<? extends Packet>, List<Pair<Receiver, Method>>> packetMethods = Maps.newHashMap();
    protected final List<Receiver> receivers = Lists.newArrayList();

    @Override
    public void registerReceiver(Receiver receiver) {
        this.receivers.add(receiver);
        for (Method method : receiver.getClass().getDeclaredMethods()) {
            Class<?> packetClass;
            if (method.getAnnotation(PacketHandler.class) == null || method.getParameterTypes().length != 1 || !method.getReturnType().equals(Void.TYPE) && !Packet.class.isAssignableFrom(method.getReturnType()) || !Packet.class.isAssignableFrom(packetClass = method.getParameterTypes()[0]) || Modifier.isAbstract(packetClass.getModifiers())) continue;
            try {
                this.packetMethods.compute(packetClass, (k, v) -> {
                    if (v == null) {
                        v = Lists.newArrayList();
                    }
                    v.add(Pair.of(receiver, method));
                    return v;
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void unregister(Plugin plugin) {
        for (Receiver receiver : this.receivers) {
            receiver.unregister(plugin);
        }
    }
}

