/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.util.config;

import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import top.focess.qq.api.util.yaml.YamlConfiguration;
import top.focess.qq.api.util.yaml.YamlLoadException;

public abstract class Config {
    @Nullable
    private final File file;
    protected YamlConfiguration yaml;

    protected Config(@Nullable File file) throws YamlLoadException {
        this.file = file;
        this.yaml = this.file != null && this.file.exists() ? YamlConfiguration.loadFile(file) : new YamlConfiguration(null);
    }

    @Nullable
    public File getFile() {
        return this.file;
    }

    protected <T> T get(String key) {
        return this.yaml.get(key);
    }

    protected void set(String key, Object value) {
        this.yaml.set(key, value);
    }

    protected void save() {
        this.yaml.save(this.file);
    }

    protected Map<String, Object> getValues() {
        return this.yaml.getValues();
    }

    protected boolean contains(String key) {
        return this.yaml.contains(key);
    }

    protected void remove(String key) {
        this.yaml.remove(key);
    }
}

