/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.net;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.net.IllegalPortException;
import top.focess.qq.api.net.PacketPreCodec;
import top.focess.qq.api.net.Receiver;
import top.focess.qq.api.net.ServerReceiver;
import top.focess.qq.api.net.packet.Packet;
import top.focess.qq.api.util.Pair;
import top.focess.qq.core.net.ASocket;

public class FocessSidedSocket
extends ASocket {
    private final int localPort;
    private final ServerSocket server;
    private final Thread thread;

    public FocessSidedSocket(int localPort) throws IllegalPortException {
        this.localPort = localPort;
        try {
            this.server = new ServerSocket(localPort);
        }
        catch (IOException e) {
            throw new IllegalPortException(localPort);
        }
        this.thread = new Thread(() -> {
            FocessQQ.getLogger().debugLang("start-focess-sided-socket", localPort);
            while (!this.server.isClosed()) {
                try {
                    int length;
                    Socket socket = this.server.accept();
                    InputStream inputStream = socket.getInputStream();
                    byte[] buffer = new byte[1024];
                    PacketPreCodec packetPreCodec = new PacketPreCodec();
                    while ((length = inputStream.read(buffer)) != -1) {
                        packetPreCodec.push(buffer, length);
                    }
                    Packet packet = packetPreCodec.readPacket();
                    OutputStream outputStream = socket.getOutputStream();
                    if (packet != null) {
                        for (Pair pair : (List)this.packetMethods.getOrDefault(packet.getClass(), Lists.newArrayList())) {
                            Method method = (Method)pair.getValue();
                            try {
                                method.setAccessible(true);
                                Object o = method.invoke(pair.getKey(), packet);
                                if (o == null) continue;
                                PacketPreCodec handler = new PacketPreCodec();
                                handler.writePacket((Packet)o);
                                outputStream.write(handler.getBytes());
                                outputStream.flush();
                            }
                            catch (Exception e) {
                                FocessQQ.getLogger().thrLang("exception-handle-packet", e, new Object[0]);
                            }
                        }
                    }
                    socket.shutdownOutput();
                }
                catch (IOException e) {
                    FocessQQ.getLogger().thrLang("exception-focess-sided-socket", e, new Object[0]);
                    if (!this.server.isClosed()) continue;
                    return;
                }
            }
        });
        this.thread.start();
    }

    @Override
    public boolean close() {
        boolean ret = false;
        for (Receiver receiver : this.receivers) {
            ret = ret || receiver.close();
        }
        try {
            this.server.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public void registerReceiver(Receiver receiver) {
        if (!(receiver instanceof ServerReceiver)) {
            throw new UnsupportedOperationException();
        }
        super.registerReceiver(receiver);
    }

    @Override
    public boolean containsServerSide() {
        return true;
    }

    @Override
    public boolean containsClientSide() {
        return false;
    }

    public int getLocalPort() {
        return this.localPort;
    }
}

