/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.command;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.command.Command;
import top.focess.qq.api.command.CommandSender;
import top.focess.qq.api.event.EventManager;
import top.focess.qq.api.event.EventSubmitException;
import top.focess.qq.api.event.command.CommandPrepostEvent;
import top.focess.qq.api.schedule.Scheduler;
import top.focess.qq.api.schedule.Schedulers;
import top.focess.qq.api.util.CombinedFuture;
import top.focess.qq.api.util.IOHandler;

public class CommandLine {
    private static final Scheduler EXECUTOR = Schedulers.newThreadPoolScheduler(FocessQQ.getMainPlugin(), 7, false, "CommandLine");

    @NotNull
    public static Future<Boolean> exec(String command) {
        return CommandLine.exec(CommandSender.CONSOLE, command);
    }

    @NotNull
    public static Future<Boolean> exec(CommandSender sender, String command) {
        return CommandLine.exec(sender, command, sender.getIOHandler());
    }

    @NotNull
    public static Future<Boolean> exec(CommandSender sender, String command, IOHandler ioHandler) {
        if (sender == CommandSender.CONSOLE) {
            FocessQQ.getLogger().consoleInput(command);
        }
        ArrayList args = Lists.newArrayList();
        StringBuilder stringBuilder = new StringBuilder();
        boolean stack = false;
        boolean ignore = false;
        for (char c : command.toCharArray()) {
            if (ignore) {
                ignore = false;
                switch (c) {
                    case 'a': {
                        stringBuilder.append('\u0007');
                        break;
                    }
                    case 'b': {
                        stringBuilder.append('\b');
                        break;
                    }
                    case 'f': {
                        stringBuilder.append('\f');
                        break;
                    }
                    case 'n': {
                        stringBuilder.append('\n');
                        break;
                    }
                    case 'r': {
                        stringBuilder.append('\r');
                        break;
                    }
                    case 't': {
                        stringBuilder.append('\t');
                        break;
                    }
                    case 'v': {
                        stringBuilder.append('\u000b');
                        break;
                    }
                    case '0': {
                        stringBuilder.append('\u0000');
                        break;
                    }
                    default: {
                        stringBuilder.append(c);
                        break;
                    }
                }
                continue;
            }
            if (c == '\\') {
                ignore = true;
                continue;
            }
            if (c == ' ') {
                if (!stack) {
                    if (stringBuilder.length() <= 0) continue;
                    args.add(stringBuilder.toString());
                    stringBuilder.delete(0, stringBuilder.length());
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            if (c == '\"') {
                stack = !stack;
                continue;
            }
            stringBuilder.append(c);
        }
        if (stringBuilder.length() != 0) {
            args.add(stringBuilder.toString());
        }
        if (args.size() == 0) {
            return CompletableFuture.completedFuture(false);
        }
        String name = (String)args.get(0);
        args.remove(0);
        return CommandLine.exec0(sender, name, args.toArray(new String[0]), ioHandler, command);
    }

    private static Future<Boolean> exec0(CommandSender sender, String command, String[] args, IOHandler ioHandler, String rawCommand) {
        boolean flag = false;
        CombinedFuture ret = new CombinedFuture();
        for (Command com : Command.getCommands()) {
            if (!com.getAliases().stream().anyMatch(i -> i.equalsIgnoreCase(command)) && !com.getName().equalsIgnoreCase(command)) continue;
            CommandPrepostEvent event = new CommandPrepostEvent(sender, com, args, ioHandler);
            try {
                EventManager.submit(event);
            }
            catch (EventSubmitException e) {
                FocessQQ.getLogger().thrLang("exception-submit-command-prepost-event", e, new Object[0]);
            }
            if (event.isCancelled()) continue;
            if (sender != CommandSender.CONSOLE) {
                IOHandler.getConsoleIoHandler().outputLang("command-exec", sender.toString(), rawCommand);
            }
            flag = true;
            ret.combine(EXECUTOR.submit(() -> com.execute(sender, args, ioHandler)));
        }
        if (!flag && sender == CommandSender.CONSOLE) {
            ioHandler.outputLang("unknown-command", command);
        }
        return ret;
    }
}

