/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.command;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import net.mamoe.mirai.contact.Friend;
import net.mamoe.mirai.contact.Member;
import net.mamoe.mirai.contact.Stranger;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.bot.Bot;
import top.focess.qq.api.command.CommandLine;
import top.focess.qq.api.command.CommandPermission;
import top.focess.qq.api.util.IOHandler;
import top.focess.qq.api.util.session.Session;
import top.focess.qq.core.listeners.ChatListener;

public class CommandSender {
    private static final Map<CommandSender, Session> SESSIONS = Maps.newHashMap();
    public static final CommandSender CONSOLE = new CommandSender();
    private final Member member;
    private final Friend friend;
    private final Stranger stranger;
    private final Bot bot;
    private final boolean isMember;
    private final boolean isFriend;
    private final CommandPermission permission;
    private final boolean isStranger;

    private CommandSender() {
        this.member = null;
        this.friend = null;
        this.stranger = null;
        this.bot = null;
        this.isFriend = false;
        this.isMember = false;
        this.isStranger = false;
        this.permission = CommandPermission.OWNER;
    }

    public CommandSender(@NonNull Friend friend) {
        this.member = null;
        this.stranger = null;
        this.friend = friend;
        this.bot = FocessQQ.getBotManager().getBot(friend.getBot().getId());
        this.isFriend = true;
        this.isMember = false;
        this.isStranger = false;
        this.permission = CommandPermission.OWNER;
    }

    public CommandSender(@NonNull Member member) {
        this.member = member;
        this.stranger = null;
        this.friend = null;
        this.bot = FocessQQ.getBotManager().getBot(member.getBot().getId());
        this.isMember = true;
        this.isFriend = false;
        this.isStranger = false;
        this.permission = CommandPermission.toCommandPermission(member.getPermission());
    }

    public CommandSender(@NonNull Stranger stranger) {
        this.member = null;
        this.friend = null;
        this.stranger = stranger;
        this.bot = FocessQQ.getBotManager().getBot(this.stranger.getBot().getId());
        this.isMember = false;
        this.isFriend = false;
        this.isStranger = true;
        this.permission = CommandPermission.OWNER;
    }

    public @Nullable Friend getFriend() {
        return this.friend;
    }

    public boolean isFriend() {
        return this.isFriend;
    }

    public boolean hasPermission(CommandPermission permission) {
        if (this.isAdministrator()) {
            return true;
        }
        return this.permission.hasPermission(permission);
    }

    public @Nullable Member getMember() {
        return this.member;
    }

    @EnsuresNonNullIf(expression={"getMember()"}, result=true)
    public boolean isMember() {
        return this.isMember;
    }

    public boolean isAdministrator() {
        return this.isFriend ? this.friend.getId() == FocessQQ.getAdministratorId() : this.isMember && this.member.getId() == FocessQQ.getAdministratorId();
    }

    public @NonNull CommandPermission getPermission() {
        return this.permission;
    }

    public String toString() {
        if (this.isFriend()) {
            return this.friend.getNick() + "(" + this.friend.getId() + ")";
        }
        if (this.isMember) {
            return this.member.getNameCard() + "(" + this.member.getId() + ")[" + this.member.getGroup().getId() + "]";
        }
        return "CONSOLE";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandSender sender = (CommandSender)o;
        if (this.isMember() && sender.isMember()) {
            return sender.getMember().getGroup() == this.getMember().getGroup() && sender.getMember().getId() == this.getMember().getId();
        }
        if (this.isFriend() && sender.isFriend()) {
            return sender.getFriend().getId() == this.getFriend().getId();
        }
        return this.isConsole() && sender.isConsole();
    }

    public int hashCode() {
        return Objects.hash(this.member == null ? null : Long.valueOf(this.member.getId()), this.friend == null ? null : Long.valueOf(this.friend.getId()), this.isMember, this.isFriend);
    }

    public boolean isConsole() {
        return this == CONSOLE;
    }

    public IOHandler getIOHandler() {
        if (this.isConsole()) {
            return IOHandler.getConsoleIoHandler();
        }
        return new IOHandler(){

            @Override
            public void output(String output) {
                if (CommandSender.this.isMember()) {
                    CommandSender.this.getMember().getGroup().sendMessage(output);
                } else if (CommandSender.this.isFriend()) {
                    CommandSender.this.getFriend().sendMessage(output);
                }
            }

            @Override
            public boolean hasInput(boolean flag) {
                ChatListener.registerInputListener(this, CommandSender.this, flag);
                while (!this.flag) {
                }
                return true;
            }
        };
    }

    public void exec(String command) {
        CommandLine.exec(this, command);
    }

    public Session getSession() {
        if (SESSIONS.containsKey(this)) {
            return SESSIONS.get(this);
        }
        Session session = new Session(null);
        SESSIONS.put(this, session);
        return session;
    }

    public @Nullable Bot getBot() {
        return this.bot;
    }

    public boolean isStranger() {
        return this.isStranger;
    }
}

