/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.util.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import top.focess.qq.api.util.SectionMap;
import top.focess.qq.api.util.json.JSONList;
import top.focess.qq.api.util.json.JSONParseException;
import top.focess.qq.api.util.json.JSONSection;

public class JSON
implements SectionMap {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<Map<String, Object>> TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private final Map<String, Object> values;

    public JSON(String json) {
        try {
            this.values = (Map)OBJECT_MAPPER.readValue(json, TYPE_REFERENCE);
        }
        catch (IOException e) {
            throw new JSONParseException(json);
        }
    }

    public JSON(Map<String, Object> values) {
        this.values = values;
    }

    @Override
    public JSONSection createSection(String key) {
        HashMap values = Maps.newHashMap();
        this.values.put(key, values);
        return new JSONSection(this, values);
    }

    @Override
    public Map<String, Object> getValues() {
        return this.values;
    }

    @Override
    public JSONSection getSection(String key) {
        if (this.get(key) instanceof Map) {
            return new JSONSection(this, (Map)this.get(key));
        }
        throw new IllegalStateException("This " + key + " is not a valid section.");
    }

    public JSONList getList(String key) {
        if (this.get(key) instanceof List) {
            return new JSONList((List)this.get(key));
        }
        throw new IllegalStateException("This " + key + " is not a valid list.");
    }

    public String toJson() {
        try {
            return OBJECT_MAPPER.writeValueAsString(this.values);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.values.toString();
    }
}

