/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.util.logger;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.core.plugin.PluginCoreClassLoader;
import top.focess.qq.core.util.MethodCaller;

public class FocessLogger {
    private static final Logger LOG = LoggerFactory.getLogger(FocessLogger.class);
    private static FocessLogger FOCESS_LOG;

    public FocessLogger() {
        if (FOCESS_LOG != null) {
            throw new UnsupportedOperationException();
        }
        FOCESS_LOG = this;
    }

    public void info(String message) {
        LOG.info("[FocessQQ][Console] -> " + message);
    }

    public void infoLang(String key, Object ... objects) {
        Plugin plugin = PluginCoreClassLoader.getClassLoadedBy(MethodCaller.getCallerClass());
        if (plugin == null) {
            this.info(String.format(FocessQQ.getLangConfig().get(key), objects));
        } else {
            this.info(String.format(plugin.getLangConfig().get(key), objects));
        }
    }

    public void consoleInput(String message) {
        LOG.debug("[FocessQQ][Console] <- " + message);
    }

    public void thr(String message, Throwable e) {
        LOG.error(message, e);
    }

    public void thrLang(String key, Throwable e, Object ... objects) {
        Plugin plugin = PluginCoreClassLoader.getClassLoadedBy(MethodCaller.getCallerClass());
        if (plugin == null) {
            this.thr(String.format(FocessQQ.getLangConfig().get(key), objects), e);
        } else {
            this.thr(String.format(plugin.getLangConfig().get(key), objects), e);
        }
    }

    public void fatal(String message) {
        LOG.error("[FocessQQ] + " + message);
    }

    public void fatalLang(String key, Object ... objects) {
        Plugin plugin = PluginCoreClassLoader.getClassLoadedBy(MethodCaller.getCallerClass());
        if (plugin == null) {
            this.fatal(String.format(FocessQQ.getLangConfig().get(key), objects));
        } else {
            this.fatal(String.format(plugin.getLangConfig().get(key), objects));
        }
    }

    public void debug(String message) {
        LOG.debug("[FocessQQ] - " + message);
    }

    public void debugLang(String key, Object ... objects) {
        Plugin plugin = PluginCoreClassLoader.getClassLoadedBy(MethodCaller.getCallerClass());
        if (plugin == null) {
            this.debug(String.format(FocessQQ.getLangConfig().get(key), objects));
        } else {
            this.debug(String.format(plugin.getLangConfig().get(key), objects));
        }
    }

    public void trace(String message, Throwable e) {
        LOG.trace(message, e);
    }
}

