/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.util.option;

import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.util.Map;
import java.util.Queue;
import top.focess.qq.core.util.option.OptionParserClassifier;
import top.focess.qq.core.util.option.type.OptionType;

public class Option {
    private final OptionParserClassifier classifier;
    private final Map<OptionType<?>, Queue<String>> optionTypes = Maps.newHashMap();

    public Option(OptionParserClassifier classifier) {
        this.classifier = classifier;
    }

    public String getName() {
        return this.classifier.getName();
    }

    public void put(OptionType<?> optionType, String value) {
        this.optionTypes.compute(optionType, (k, v) -> {
            if (v == null) {
                v = Queues.newConcurrentLinkedQueue();
            }
            v.offer(value);
            return v;
        });
    }

    public <T> T get(OptionType<T> optionType) {
        Queue<String> options = this.optionTypes.getOrDefault(optionType, Queues.newConcurrentLinkedQueue());
        T t = optionType.parse(options.poll());
        this.optionTypes.put(optionType, options);
        return t;
    }

    public String toString() {
        return "Option{optionTypes=" + this.optionTypes + '}';
    }
}

