/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class CombinedFuture
implements Future<Boolean> {
    private final List<Future<Boolean>> futures = Lists.newArrayList();

    public void combine(Future<Boolean> future) {
        this.futures.add(future);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean ret = true;
        for (Future<Boolean> future : this.futures) {
            if (future.cancel(mayInterruptIfRunning)) continue;
            ret = false;
        }
        return ret;
    }

    @Override
    public boolean isCancelled() {
        boolean ret = true;
        for (Future<Boolean> future : this.futures) {
            if (future.isCancelled()) continue;
            ret = false;
        }
        return ret;
    }

    @Override
    public boolean isDone() {
        boolean ret = true;
        for (Future<Boolean> future : this.futures) {
            if (future.isDone()) continue;
            ret = false;
        }
        return ret;
    }

    @Override
    public Boolean get() throws InterruptedException, ExecutionException {
        boolean ret = false;
        for (Future<Boolean> future : this.futures) {
            if (!future.get().booleanValue()) continue;
            ret = true;
        }
        return ret;
    }

    @Override
    public Boolean get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean ret = false;
        for (Future<Boolean> future : this.futures) {
            if (!future.get(timeout, unit).booleanValue()) continue;
            ret = true;
        }
        return ret;
    }
}

