/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.listeners;

import com.google.common.collect.Queues;
import java.time.Duration;
import java.util.Queue;
import java.util.concurrent.Future;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.command.CommandLine;
import top.focess.qq.api.event.EventHandler;
import top.focess.qq.api.event.EventManager;
import top.focess.qq.api.event.EventPriority;
import top.focess.qq.api.event.Listener;
import top.focess.qq.api.event.chat.ConsoleChatEvent;
import top.focess.qq.api.event.message.ConsoleMessageEvent;
import top.focess.qq.api.schedule.Scheduler;
import top.focess.qq.api.schedule.Schedulers;
import top.focess.qq.api.util.IOHandler;
import top.focess.qq.api.util.InputTimeoutException;
import top.focess.qq.api.util.Pair;
import top.focess.qq.core.debug.Section;

public class ConsoleListener
implements Listener {
    private static final Scheduler EXECUTOR = Schedulers.newThreadPoolScheduler(FocessQQ.getMainPlugin(), 5, true, "ConsoleListener");
    public static final Queue<Pair<IOHandler, Long>> QUESTS = Queues.newLinkedBlockingQueue();

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onConsoleChat(ConsoleChatEvent event) {
        Pair<IOHandler, Long> element = QUESTS.poll();
        if (element != null) {
            while (element != null && System.currentTimeMillis() - element.getValue() > 300000L) {
                element.getKey().input(null);
                element = QUESTS.poll();
            }
            if (element == null) {
                return;
            }
            element.getKey().input(event.getMessage());
            return;
        }
        try {
            Future<Boolean> ret = CommandLine.exec(event.getMessage());
            EXECUTOR.run(() -> {
                Section section;
                block5: {
                    section = Section.startSection("command-console-exec", ret, Duration.ofMinutes(10L));
                    try {
                        if (!((Boolean)ret.get()).booleanValue()) {
                            ConsoleMessageEvent consoleMessageEvent = new ConsoleMessageEvent(event.getMessage());
                            try {
                                EventManager.submit(consoleMessageEvent);
                            }
                            catch (Exception e) {
                                FocessQQ.getLogger().thrLang("exception-submit-console-message-event", e, new Object[0]);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (e.getCause() instanceof InputTimeoutException) break block5;
                        FocessQQ.getLogger().thrLang("exception-exec-console-command", e, new Object[0]);
                    }
                }
                section.stop();
            });
        }
        catch (Exception e) {
            FocessQQ.getLogger().thrLang("exception-exec-console-command", e, new Object[0]);
        }
    }

    public static void registerInputListener(IOHandler ioHandler) {
        QUESTS.offer(Pair.of(ioHandler, System.currentTimeMillis()));
    }
}

