/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.command;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.focess.qq.api.command.DataCollection;
import top.focess.qq.api.command.DataConverter;

public class CommandArgument<V> {
    private final DataConverter<V> dataConverter;
    private final V value;
    private final boolean isNullable;

    private CommandArgument(@NotNull DataConverter<V> dataConverter, @Nullable V value) {
        this.dataConverter = dataConverter;
        this.value = value;
        this.isNullable = false;
    }

    private CommandArgument(@NotNull DataConverter<V> dataConverter, boolean isNullable) {
        this.dataConverter = dataConverter;
        this.value = null;
        this.isNullable = isNullable;
    }

    public static CommandArgument<String> ofString() {
        return new CommandArgument<Object>(DataConverter.DEFAULT_DATA_CONVERTER, null);
    }

    public static CommandArgument<Long> ofLong() {
        return new CommandArgument<Object>(DataConverter.LONG_DATA_CONVERTER, null);
    }

    public static CommandArgument<Integer> ofInt() {
        return new CommandArgument<Object>(DataConverter.INTEGER_DATA_CONVERTER, null);
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isDefault() {
        return this.value != null;
    }

    public V getValue() {
        return this.value;
    }

    public DataConverter<V> getDataConverter() {
        return this.dataConverter;
    }

    public static <V> CommandArgument<V> of(DataConverter<V> defaultDataConverter) {
        return new CommandArgument<Object>(defaultDataConverter, null);
    }

    @NotNull
    public static CommandArgument<String> of(@NotNull String value) {
        return new CommandArgument<String>(DataConverter.DEFAULT_DATA_CONVERTER, value);
    }

    @NotNull
    public static <V> CommandArgument<V> of(@NotNull DataConverter<V> dataConverter, @NotNull V value) {
        return new CommandArgument<V>(dataConverter, value);
    }

    @NotNull
    public static <V> CommandArgument<V> ofNullable(@NotNull DataConverter<V> dataConverter) {
        return new CommandArgument<V>(dataConverter, true);
    }

    public boolean accept(String arg) {
        if (this.isDefault()) {
            return this.getDataConverter().accept(arg) && this.getValue().equals(this.getDataConverter().convert(arg));
        }
        return this.getDataConverter().accept(arg);
    }

    public void put(DataCollection dataCollection, String arg) {
        if (!this.isDefault()) {
            this.getDataConverter().put(dataCollection, arg);
        }
    }

    public String toString() {
        return "CommandArgument{dataConverter=" + this.dataConverter + ", value=" + this.value + ", isNullable=" + this.isNullable + '}';
    }
}

