/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.command.Command;
import top.focess.qq.api.command.DataCollection;
import top.focess.qq.api.command.DataConverter;
import top.focess.qq.api.event.Event;
import top.focess.qq.api.event.EventHandler;
import top.focess.qq.api.event.Listener;
import top.focess.qq.api.event.ListenerHandler;
import top.focess.qq.api.plugin.PluginDescription;
import top.focess.qq.api.plugin.PluginDuplicateException;
import top.focess.qq.api.plugin.PluginLoaderException;
import top.focess.qq.api.plugin.PluginUnloadException;
import top.focess.qq.api.util.config.DefaultConfig;
import top.focess.qq.api.util.config.LangConfig;
import top.focess.qq.api.util.version.Version;
import top.focess.qq.api.util.yaml.YamlConfiguration;
import top.focess.qq.api.util.yaml.YamlLoadException;
import top.focess.qq.core.plugin.PluginClassLoader;
import top.focess.qq.core.plugin.PluginCoreClassLoader;
import top.focess.qq.core.util.MethodCaller;

public abstract class Plugin {
    private String author;
    private Version version;
    private String name;
    private LangConfig langConfig;
    private DefaultConfig defaultConfig;
    private PluginDescription pluginDescription;
    private boolean isEnabled = false;

    public Plugin(String name, String author, Version version) {
        this.name = name;
        this.author = author;
        this.version = version;
        this.init();
    }

    protected Plugin() {
    }

    private void init() {
        File config;
        if (!(this.getClass().getClassLoader() instanceof PluginClassLoader) && this.getClass() != FocessQQ.MainPlugin.class) {
            throw new PluginLoaderException(this.name);
        }
        if (this.getClass() != FocessQQ.MainPlugin.class || FocessQQ.isRunning()) {
            if (Plugin.getPlugin(this.getClass()) != null) {
                throw new PluginDuplicateException(this.name, "Cannot new a plugin at runtime");
            }
            this.pluginDescription = new PluginDescription(YamlConfiguration.load(this.loadResource("plugin.yml")));
        } else {
            this.pluginDescription = new PluginDescription();
        }
        if (!this.getClass().getName().equals(this.pluginDescription.getMain())) {
            throw new IllegalStateException("Cannot new a plugin at runtime");
        }
        if (!this.getDefaultFolder().exists() && !this.getDefaultFolder().mkdirs()) {
            FocessQQ.getLogger().debugLang("create-default-folder-failed", this.getDefaultFolder().getAbsolutePath());
        }
        if (!(config = new File(this.getDefaultFolder(), "config.yml")).exists()) {
            try {
                InputStream configResource = this.loadResource("config.yml");
                if (configResource != null) {
                    Files.copy(configResource, config.toPath(), new CopyOption[0]);
                    configResource.close();
                } else if (!config.createNewFile()) {
                    FocessQQ.getLogger().debugLang("create-config-file-failed", config.getAbsolutePath());
                }
            }
            catch (IOException e) {
                FocessQQ.getLogger().thrLang("exception-create-config-file", e, new Object[0]);
            }
        }
        try {
            this.defaultConfig = new DefaultConfig(config);
        }
        catch (YamlLoadException e) {
            FocessQQ.getLogger().thrLang("exception-load-default-configuration", e, new Object[0]);
        }
        this.langConfig = new LangConfig(this.loadResource("lang.yml"));
    }

    public static @Nullable Plugin getPlugin(Class<? extends Plugin> plugin) {
        return PluginClassLoader.getPlugin(plugin);
    }

    public static @Nullable Plugin getPlugin(String name) {
        return PluginClassLoader.getPlugin(name);
    }

    public static @Nullable Plugin thisPlugin() {
        return PluginCoreClassLoader.getClassLoadedBy(MethodCaller.getCallerClass());
    }

    public @NonNull String getName() {
        return this.name;
    }

    public abstract void enable();

    public abstract void disable();

    public final void onEnable() {
        this.isEnabled = true;
        this.enable();
    }

    public final void onDisable() {
        this.disable();
        this.isEnabled = false;
    }

    public @NonNull File getDefaultFolder() {
        return new File(new File("plugins"), this.getName());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plugin plugin = (Plugin)o;
        return Objects.equals(this.name, plugin.name);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public void registerListener(Listener listener) {
        ListenerHandler.register(this, listener);
        for (Method method : listener.getClass().getDeclaredMethods()) {
            Class<?> eventClass;
            EventHandler handler = method.getAnnotation(EventHandler.class);
            if (handler == null || method.getParameterTypes().length != 1 || !Event.class.isAssignableFrom(eventClass = method.getParameterTypes()[0]) || Modifier.isAbstract(eventClass.getModifiers())) continue;
            try {
                Field field = eventClass.getDeclaredField("LISTENER_HANDLER");
                boolean flag = field.isAccessible();
                field.setAccessible(true);
                ListenerHandler listenerHandler = (ListenerHandler)field.get(null);
                field.setAccessible(flag);
                listenerHandler.register(listener, method, handler);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void registerCommand(Command command) {
        Command.register(this, command);
    }

    public void registerBuffer(DataConverter<?> dataConverter, DataCollection.BufferGetter bufferGetter) {
        DataCollection.register(this, dataConverter, bufferGetter);
    }

    public String getAuthor() {
        return this.author;
    }

    public Version getVersion() {
        return this.version;
    }

    public LangConfig getLangConfig() {
        return this.langConfig;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public PluginDescription getPluginDescription() {
        return this.pluginDescription;
    }

    public @Nullable InputStream loadResource(String path) {
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void unload() {
        throw new PluginUnloadException();
    }
}

