/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.command.Command;
import top.focess.qq.api.command.CommandResult;
import top.focess.qq.api.command.CommandSender;
import top.focess.qq.api.command.SpecialArgumentHandler;
import top.focess.qq.api.event.EventManager;
import top.focess.qq.api.event.EventSubmitException;
import top.focess.qq.api.event.command.CommandPrepostEvent;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.api.schedule.Scheduler;
import top.focess.qq.api.schedule.Schedulers;
import top.focess.qq.api.util.IOHandler;
import top.focess.qq.api.util.Pair;

public class CommandLine {
    private static final Map<String, SpecialArgumentHandler> SPECIAL_ARGUMENT_HANDLERS = Maps.newHashMap();
    private static final Map<Plugin, List<Pair<String, SpecialArgumentHandler>>> PLUGIN_SPECIAL_ARGUMENT_MAP = Maps.newConcurrentMap();
    private static final Scheduler EXECUTOR = Schedulers.newThreadPoolScheduler(FocessQQ.getMainPlugin(), 7, false, "CommandLine");

    @NotNull
    public static Future<CommandResult> exec(String command) {
        return CommandLine.exec(CommandSender.CONSOLE, command);
    }

    @NotNull
    public static Future<CommandResult> exec(CommandSender sender, String command) {
        return CommandLine.exec(sender, command, sender.getIOHandler());
    }

    @NotNull
    public static Future<CommandResult> exec(CommandSender sender, String command, IOHandler ioHandler) {
        if (sender == CommandSender.CONSOLE) {
            FocessQQ.getLogger().consoleInput(command);
        }
        ArrayList args = Lists.newArrayList();
        StringBuilder stringBuilder = new StringBuilder();
        boolean stack = false;
        boolean ignore = false;
        for (char c : command.toCharArray()) {
            if (ignore) {
                ignore = false;
                switch (c) {
                    case 'a': {
                        stringBuilder.append('\u0007');
                        break;
                    }
                    case 'b': {
                        stringBuilder.append('\b');
                        break;
                    }
                    case 'f': {
                        stringBuilder.append('\f');
                        break;
                    }
                    case 'n': {
                        stringBuilder.append('\n');
                        break;
                    }
                    case 'r': {
                        stringBuilder.append('\r');
                        break;
                    }
                    case 't': {
                        stringBuilder.append('\t');
                        break;
                    }
                    case 'v': {
                        stringBuilder.append('\u000b');
                        break;
                    }
                    case '0': {
                        stringBuilder.append('\u0000');
                        break;
                    }
                    default: {
                        stringBuilder.append(c);
                        break;
                    }
                }
                continue;
            }
            if (c == '\\') {
                ignore = true;
                continue;
            }
            if (c == ' ') {
                if (!stack) {
                    if (stringBuilder.length() <= 0) continue;
                    args.add(stringBuilder.toString());
                    stringBuilder.delete(0, stringBuilder.length());
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            if (c == '\"') {
                stack = !stack;
                continue;
            }
            if (c == '@' && !stack) {
                stringBuilder.append('\"');
                stringBuilder.append('@');
                continue;
            }
            stringBuilder.append(c);
        }
        if (stringBuilder.length() != 0) {
            args.add(stringBuilder.toString());
        }
        if (args.size() == 0) {
            return CompletableFuture.completedFuture(CommandResult.NONE);
        }
        String name = (String)args.get(0);
        args.remove(0);
        return CommandLine.exec0(sender, name, args.toArray(new String[0]), ioHandler, command);
    }

    private static Future<CommandResult> exec0(CommandSender sender, String command, String[] args, IOHandler ioHandler, String rawCommand) {
        boolean flag = false;
        Future<CommandResult> ret = CompletableFuture.completedFuture(CommandResult.NONE);
        for (Command com : Command.getCommands()) {
            if (!com.getAliases().stream().anyMatch(i -> i.equalsIgnoreCase(command)) && !com.getName().equalsIgnoreCase(command)) continue;
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (!args[i2].startsWith("\"@")) continue;
                String head = args[i2].substring(2);
                args[i2] = SPECIAL_ARGUMENT_HANDLERS.containsKey(head) ? SPECIAL_ARGUMENT_HANDLERS.get(head).handle(sender, com, args, i2) : args[i2].substring(1);
            }
            CommandPrepostEvent event = new CommandPrepostEvent(sender, com, args, ioHandler);
            try {
                EventManager.submit(event);
            }
            catch (EventSubmitException e) {
                FocessQQ.getLogger().thrLang("exception-submit-command-prepost-event", e, new Object[0]);
            }
            if (event.isCancelled()) continue;
            sender.getSession().set("@previous_command", rawCommand);
            if (sender != CommandSender.CONSOLE) {
                IOHandler.getConsoleIoHandler().outputLang("command-exec", sender.toString(), rawCommand);
            }
            flag = true;
            ret = EXECUTOR.submit(() -> com.execute(sender, args, ioHandler));
        }
        if (!flag && sender == CommandSender.CONSOLE) {
            ioHandler.outputLang("unknown-command", command);
        }
        return ret;
    }

    public static void register(Plugin plugin, String name, SpecialArgumentHandler handler) {
        PLUGIN_SPECIAL_ARGUMENT_MAP.compute(plugin, (k, v) -> {
            if (v == null) {
                v = Lists.newArrayList();
            }
            String n = plugin == FocessQQ.getMainPlugin() ? name : plugin.getName() + ":" + name;
            v.add(Pair.of(n, handler));
            SPECIAL_ARGUMENT_HANDLERS.put(n, handler);
            return v;
        });
    }

    public static void unregister(Plugin plugin) {
        for (Pair<String, SpecialArgumentHandler> pair : PLUGIN_SPECIAL_ARGUMENT_MAP.getOrDefault(plugin, Lists.newArrayList())) {
            SPECIAL_ARGUMENT_HANDLERS.remove(pair.getLeft());
        }
        PLUGIN_SPECIAL_ARGUMENT_MAP.remove(plugin);
    }

    public static boolean unregisterAll() {
        boolean flag = false;
        for (Plugin plugin : PLUGIN_SPECIAL_ARGUMENT_MAP.keySet()) {
            if (plugin != FocessQQ.getMainPlugin()) {
                flag = true;
            }
            CommandLine.unregister(plugin);
        }
        return flag;
    }
}

