/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.util.config;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import top.focess.qq.api.util.yaml.YamlConfiguration;
import top.focess.qq.api.util.yaml.YamlLoadException;

public abstract class Config {
    private final @Nullable File file;
    protected YamlConfiguration yaml;

    protected Config(@Nullable File file) throws YamlLoadException {
        this.file = file;
        this.yaml = this.file != null && this.file.exists() ? YamlConfiguration.loadFile(file) : new YamlConfiguration(null);
    }

    protected Config(@Nullable InputStream stream) {
        this.file = null;
        this.yaml = YamlConfiguration.load(stream);
    }

    public @Nullable File getFile() {
        return this.file;
    }

    protected <T> @Nullable T get(String key) {
        return this.yaml.get(key);
    }

    protected void set(String key, Object value) {
        this.yaml.set(key, value);
    }

    protected void save() {
        if (this.file == null) {
            throw new UnsupportedOperationException("File is null");
        }
        this.yaml.save(this.file);
    }

    protected Map<String, Object> getValues() {
        return this.yaml.getValues();
    }

    protected boolean contains(String key) {
        return this.yaml.contains(key);
    }

    protected void remove(String key) {
        this.yaml.remove(key);
    }
}

