/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.util.network;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.api.util.json.JSON;
import top.focess.qq.api.util.network.HttpResponse;

public class NetworkHandler {
    private static final Logger LOGGER;
    public static final MediaType JSON;
    public static final MediaType TEXT;
    private static final OkHttpClient CLIENT;
    private final Plugin plugin;

    public NetworkHandler(Plugin plugin) {
        this.plugin = plugin;
    }

    public HttpResponse request(String url, Map<String, Object> data, RequestType requestType) {
        return this.request(url, data, Maps.newHashMap(), TEXT, requestType);
    }

    public HttpResponse request(String url, RequestType requestType) {
        return this.request(url, Maps.newHashMap(), requestType);
    }

    public HttpResponse request(String url, Map<String, Object> data, Map<String, String> header, MediaType mediaType, RequestType requestType) {
        if (requestType == RequestType.GET) {
            return this.get(url, data, header);
        }
        if (requestType == RequestType.POST) {
            return this.post(url, data, header, mediaType);
        }
        if (requestType == RequestType.PUT) {
            return this.put(url, data, header, mediaType);
        }
        return HttpResponse.ofNull(this.plugin);
    }

    private String process(Map<String, Object> data) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String key : data.keySet()) {
            stringBuilder.append(key).append('=').append(data.get(key)).append('&');
        }
        if (stringBuilder.length() != 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        return "";
    }

    public HttpResponse put(String url, Map<String, Object> data, Map<String, String> header, MediaType mediaType) {
        String value = mediaType.equals((Object)JSON) ? new JSON(data).toJson() : this.process(data);
        RequestBody requestBody = RequestBody.create((String)value, (MediaType)mediaType);
        Request request = new Request.Builder().url(url).headers(Headers.of(header)).put(requestBody).build();
        try {
            Response response = CLIENT.newCall(request).execute();
            String body = response.body().string();
            LOGGER.debug("[FocessQQ] - [Network] -> [" + this.plugin.getName() + "] Put: " + data + " with Header: " + header + ", Response: " + body);
            return new HttpResponse(this.plugin, response.code(), response.headers(), body);
        }
        catch (Exception e) {
            LOGGER.debug("[FocessQQ] - [Network] -> [" + this.plugin.getName() + "] Put: " + data + " with Header: " + header + ", Error: " + e.getMessage());
            return new HttpResponse(this.plugin, e);
        }
    }

    public HttpResponse post(String url, Map<String, Object> data, Map<String, String> header, MediaType mediaType) {
        String value = mediaType.equals((Object)JSON) ? new JSON(data).toJson() : this.process(data);
        RequestBody requestBody = RequestBody.create((String)value, (MediaType)mediaType);
        Request request = new Request.Builder().url(url).headers(Headers.of(header)).post(requestBody).build();
        try {
            Response response = CLIENT.newCall(request).execute();
            String body = response.body().string();
            LOGGER.debug("[FocessQQ] - [Network] -> [" + this.plugin.getName() + "] Post: " + data + " with Header: " + header + ", Response: " + body);
            return new HttpResponse(this.plugin, response.code(), response.headers(), body);
        }
        catch (IOException e) {
            LOGGER.debug("[FocessQQ] - [Network] -> [" + this.plugin.getName() + "] Post: " + data + " with Header: " + header + ", Error: " + e.getMessage());
            return new HttpResponse(this.plugin, e);
        }
    }

    public HttpResponse get(String url, Map<String, Object> data, Map<String, String> header) {
        Request request = data.size() != 0 ? new Request.Builder().url(url + "?" + this.process(data)).get().headers(Headers.of(header)).build() : new Request.Builder().url(url).get().headers(Headers.of(header)).build();
        try {
            Response response = CLIENT.newCall(request).execute();
            String body = response.body().string();
            LOGGER.debug("[FocessQQ] - [Network] -> [" + this.plugin.getName() + "] Get: " + data + " with Header: " + header + ", Response: " + body);
            return new HttpResponse(this.plugin, response.code(), response.headers(), body);
        }
        catch (IOException e) {
            LOGGER.debug("[FocessQQ] - [Network] -> [" + this.plugin.getName() + "] Get: " + data + " with Header: " + header + ", Error: " + e.getMessage());
            return new HttpResponse(this.plugin, e);
        }
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    static {
        SSLContext sslContext;
        LOGGER = LoggerFactory.getLogger(NetworkHandler.class);
        JSON = MediaType.parse((String)"application/json; charset=utf-8");
        TEXT = MediaType.parse((String)"application/x-www-form-urlencoded; charset=utf-8");
        TrustManager[] managers = new X509TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, managers, new SecureRandom());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        CLIENT = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)managers[0]).hostnameVerifier((hostname, session) -> true).build();
    }

    public static enum RequestType {
        GET,
        POST,
        PUT;

    }
}

