/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.command.data;

import org.jetbrains.annotations.Nullable;
import top.focess.qq.api.command.Command;
import top.focess.qq.api.command.data.DataBuffer;
import top.focess.qq.api.command.data.StringBuffer;

public class CommandBuffer
extends DataBuffer<Command> {
    private final StringBuffer stringBuffer;

    public static CommandBuffer allocate(int size) {
        return new CommandBuffer(size);
    }

    public CommandBuffer(int size) {
        this.stringBuffer = StringBuffer.allocate(size);
    }

    @Override
    public void flip() {
        this.stringBuffer.flip();
    }

    @Override
    public void put(Command command) {
        this.stringBuffer.put(command.getName());
    }

    @Override
    @Nullable
    public Command get() {
        String name = this.stringBuffer.get();
        for (Command command : Command.getCommands()) {
            if (!command.getName().equals(name)) continue;
            return command;
        }
        return null;
    }

    @Override
    @Nullable
    public Command get(int index) {
        String name = this.stringBuffer.get(index);
        for (Command command : Command.getCommands()) {
            if (!command.getName().equals(name)) continue;
            return command;
        }
        return null;
    }
}

