/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.plugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.time.Duration;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.command.Command;
import top.focess.qq.api.command.CommandDuplicateException;
import top.focess.qq.api.command.CommandLine;
import top.focess.qq.api.command.CommandLoadException;
import top.focess.qq.api.command.CommandSender;
import top.focess.qq.api.command.CommandType;
import top.focess.qq.api.command.DataCollection;
import top.focess.qq.api.command.DataConverter;
import top.focess.qq.api.command.IllegalCommandClassException;
import top.focess.qq.api.command.IllegalSpecialArgumentComplexHandlerClassException;
import top.focess.qq.api.command.SpecialArgumentComplexHandler;
import top.focess.qq.api.command.SpecialArgumentType;
import top.focess.qq.api.command.converter.DataConverterType;
import top.focess.qq.api.command.converter.IllegalDataConverterClassException;
import top.focess.qq.api.command.data.DataBuffer;
import top.focess.qq.api.event.EventManager;
import top.focess.qq.api.event.EventSubmitException;
import top.focess.qq.api.event.IllegalListenerClassException;
import top.focess.qq.api.event.Listener;
import top.focess.qq.api.event.ListenerHandler;
import top.focess.qq.api.event.ListenerType;
import top.focess.qq.api.event.plugin.PluginLoadEvent;
import top.focess.qq.api.event.plugin.PluginUnloadEvent;
import top.focess.qq.api.plugin.IllegalPluginClassException;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.api.plugin.PluginDescription;
import top.focess.qq.api.plugin.PluginDuplicateException;
import top.focess.qq.api.plugin.PluginLoadException;
import top.focess.qq.api.plugin.PluginType;
import top.focess.qq.api.plugin.PluginUnloadException;
import top.focess.qq.api.schedule.Callback;
import top.focess.qq.api.schedule.Scheduler;
import top.focess.qq.api.schedule.Schedulers;
import top.focess.qq.api.schedule.Task;
import top.focess.qq.api.util.version.Version;
import top.focess.qq.api.util.yaml.YamlConfiguration;
import top.focess.qq.core.bot.SimpleBotManager;
import top.focess.qq.core.debug.Section;
import top.focess.qq.core.plugin.AnnotationHandler;
import top.focess.qq.core.plugin.FieldAnnotationHandler;
import top.focess.qq.core.plugin.PluginCoreClassLoader;
import top.focess.qq.core.plugin.ResourceHandler;

public class PluginClassLoader
extends URLClassLoader {
    private static final Map<Class<? extends Plugin>, Plugin> CLASS_PLUGIN_MAP = Maps.newConcurrentMap();
    private static final Map<String, Plugin> NAME_PLUGIN_MAP = Maps.newConcurrentMap();
    private static Field PLUGIN_NAME_FIELD;
    private static Field PLUGIN_VERSION_FIELD;
    private static Field PLUGIN_AUTHOR_FIELD;
    private static Field COMMAND_NAME_FIELD;
    private static Field COMMAND_ALIASES_FIELD;
    private static Field COMMAND_INITIALIZE_FIELD;
    private static Method PLUGIN_INIT_METHOD;
    private static final Object LOCK;
    private static final Map<String, Set<File>> AFTER_PLUGINS_MAP;
    private static final Map<Class<? extends Annotation>, AnnotationHandler> HANDLERS;
    private static final Map<Class<? extends Annotation>, FieldAnnotationHandler> FIELD_ANNOTATION_HANDLERS;
    private static final List<ResourceHandler> RESOURCE_HANDLERS;
    private static final AnnotationHandler PLUGIN_TYPE_HANDLER;
    private final JarFile jarFile;
    private PluginDescription pluginDescription;
    private static final Scheduler SCHEDULER;
    private static final Scheduler GC_SCHEDULER;
    private final File file;
    private Plugin plugin;
    private final Set<Class<?>> loadedClasses = Sets.newHashSet();

    public PluginDescription getPluginDescription() {
        return this.pluginDescription;
    }

    public static void enablePlugin(Plugin plugin) {
        if (plugin.getClass() != FocessQQ.MainPlugin.class) {
            Task task = SCHEDULER.run(() -> PluginClassLoader.enablePlugin0(plugin));
            Section section = Section.startSection("plugin-enable", task, Duration.ofSeconds(30L));
            try {
                task.join();
            }
            catch (InterruptedException | CancellationException | ExecutionException e) {
                if (e.getCause() instanceof PluginLoadException) {
                    throw (PluginLoadException)e.getCause();
                }
                if (e.getCause() instanceof PluginDuplicateException) {
                    throw (PluginDuplicateException)e.getCause();
                }
                if (e.getCause() instanceof PluginUnloadException) {
                    throw (PluginUnloadException)e.getCause();
                }
                FocessQQ.getLogger().debugLang("section-exception", section.getName(), e.getMessage());
            }
            section.stop();
        } else {
            PluginClassLoader.enablePlugin0(plugin);
        }
    }

    private static void enablePlugin0(Plugin plugin) {
        try {
            FocessQQ.getLogger().debugLang("start-enable-plugin", plugin.getName());
            plugin.onEnable();
            CLASS_PLUGIN_MAP.put(plugin.getClass(), plugin);
            NAME_PLUGIN_MAP.put(plugin.getName(), plugin);
            FocessQQ.getLogger().debugLang("end-enable-plugin", plugin.getName());
        }
        catch (Exception e) {
            if (e instanceof PluginDuplicateException) {
                throw (PluginDuplicateException)e;
            }
            throw new PluginLoadException(plugin.getClass(), e);
        }
    }

    @Nullable
    public static File disablePlugin(Plugin plugin) {
        Callback<File> callback = SCHEDULER.submit(() -> PluginClassLoader.disablePlugin0(plugin));
        Section section = Section.startSection("plugin-disable", callback, Duration.ofSeconds(5L));
        File file = null;
        try {
            file = callback.waitCall();
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            FocessQQ.getLogger().debugLang("section-exception", section.getName(), e.getMessage());
        }
        section.stop();
        if (!GC_SCHEDULER.isClosed()) {
            GC_SCHEDULER.run(System::gc, Duration.ofSeconds(1L));
        }
        return file;
    }

    @Nullable
    public static File disablePlugin0(Plugin plugin) {
        FocessQQ.getLogger().debugLang("start-disable-plugin", plugin.getName());
        try {
            plugin.onDisable();
        }
        catch (Exception e) {
            FocessQQ.getLogger().thrLang("exception-plugin-disable", e, new Object[0]);
        }
        if (plugin != FocessQQ.getMainPlugin()) {
            ListenerHandler.unregister(plugin);
            FocessQQ.getLogger().debugLang("unregister-listeners", new Object[0]);
            DataCollection.unregister(plugin);
            FocessQQ.getLogger().debugLang("unregister-buffers", new Object[0]);
            Command.unregister(plugin);
            FocessQQ.getLogger().debugLang("unregister-commands", new Object[0]);
            Schedulers.close(plugin);
            FocessQQ.getLogger().debugLang("close-schedulers", new Object[0]);
            SimpleBotManager.remove(plugin);
            FocessQQ.getLogger().debugLang("remove-bot", new Object[0]);
            CommandLine.unregister(plugin);
            FocessQQ.getLogger().debugLang("unregister-special-argument-handlers", new Object[0]);
            if (FocessQQ.getSocket() != null) {
                FocessQQ.getSocket().unregister(plugin);
            }
            if (FocessQQ.getUdpSocket() != null) {
                FocessQQ.getUdpSocket().unregister(plugin);
            }
        }
        CommandSender.clear(plugin);
        FocessQQ.getLogger().debugLang("clear-command-sender-session", plugin.getName());
        CLASS_PLUGIN_MAP.remove(plugin.getClass());
        NAME_PLUGIN_MAP.remove(plugin.getName());
        File ret = null;
        if (plugin.getClass().getClassLoader() instanceof PluginClassLoader) {
            try {
                PluginClassLoader loader = (PluginClassLoader)plugin.getClass().getClassLoader();
                PluginCoreClassLoader.LOADERS.remove(loader);
                if (loader != null) {
                    ret = loader.getFile();
                    loader.close();
                }
            }
            catch (IOException e) {
                FocessQQ.getLogger().thrLang("exception-remove-plugin-loader", e, new Object[0]);
            }
        }
        FocessQQ.getLogger().debugLang("remove-plugin-loader", new Object[0]);
        FocessQQ.getLogger().debugLang("end-disable-plugin", plugin.getName());
        PluginUnloadEvent pluginUnloadEvent = new PluginUnloadEvent(plugin);
        try {
            EventManager.submit(pluginUnloadEvent);
        }
        catch (EventSubmitException e) {
            FocessQQ.getLogger().thrLang("exception-submit-plugin-unload-event", e, new Object[0]);
        }
        return ret;
    }

    @Nullable
    public static <T extends Plugin> T getPlugin(Class<T> plugin) {
        return (T)CLASS_PLUGIN_MAP.get(plugin);
    }

    @NotNull
    public static List<Plugin> getPlugins() {
        return Lists.newArrayList(NAME_PLUGIN_MAP.values());
    }

    @Nullable
    public static Plugin getPlugin(String name) {
        return NAME_PLUGIN_MAP.get(name);
    }

    public File getFile() {
        return this.file;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public Set<Class<?>> getLoadedClasses() {
        return this.loadedClasses;
    }

    public PluginClassLoader(@NotNull File file) throws IOException {
        super(new URL[]{file.toURI().toURL()}, (ClassLoader)PluginCoreClassLoader.DEFAULT_CLASS_LOADER);
        this.file = file;
        this.jarFile = new JarFile(file);
        PluginCoreClassLoader.LOADERS.add(this);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.loadedClasses.clear();
        this.jarFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() {
        Object object = LOCK;
        synchronized (object) {
            FocessQQ.getLogger().debugLang("start-load-plugin", this.file.getName());
            try {
                Enumeration<JarEntry> entries = this.jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry jarEntry = entries.nextElement();
                    String name = jarEntry.getName();
                    for (ResourceHandler resourceHandler : RESOURCE_HANDLERS) {
                        resourceHandler.handle(name, this.jarFile.getInputStream(jarEntry), this);
                    }
                }
                FocessQQ.getLogger().debugLang("load-plugin-classes", this.loadedClasses.size());
                if (this.pluginDescription == null) {
                    FocessQQ.getLogger().debugLang("plugin-description-not-found", new Object[0]);
                    PluginCoreClassLoader.LOADERS.remove(this);
                    return false;
                }
                Class<?> pluginClass = this.findClass(this.pluginDescription.getMain(), false);
                PluginType annotation = pluginClass.getAnnotation(PluginType.class);
                if (annotation != null) {
                    if (!PLUGIN_TYPE_HANDLER.handle(pluginClass, annotation, this)) {
                        PluginCoreClassLoader.LOADERS.remove(this);
                        return false;
                    }
                } else {
                    PluginCoreClassLoader.LOADERS.remove(this);
                    return false;
                }
                PluginClassLoader.enablePlugin(this.plugin);
                FocessQQ.getLogger().debugLang("load-plugin-class", new Object[0]);
                for (Class clazz : this.loadedClasses) {
                    this.analyseClass(clazz);
                }
                FocessQQ.getLogger().debugLang("load-class", new Object[0]);
                FocessQQ.getLogger().debugLang("load-depend-plugin", new Object[0]);
                for (File file : AFTER_PLUGINS_MAP.getOrDefault(this.plugin.getName(), Sets.newHashSet())) {
                    PluginClassLoader pluginClassLoader = new PluginClassLoader(file);
                    if (pluginClassLoader.load()) {
                        FocessQQ.getLogger().infoLang("load-depend-plugin-succeed", pluginClassLoader.getPlugin().getName());
                        continue;
                    }
                    FocessQQ.getLogger().infoLang("load-depend-plugin-failed", file.getName());
                    pluginClassLoader.close();
                }
                AFTER_PLUGINS_MAP.remove(this.plugin.getName());
                PluginLoadEvent pluginLoadEvent = new PluginLoadEvent(this.plugin);
                try {
                    EventManager.submit(pluginLoadEvent);
                }
                catch (EventSubmitException eventSubmitException) {
                    FocessQQ.getLogger().thrLang("exception-submit-plugin-load-event", eventSubmitException, new Object[0]);
                }
            }
            catch (Exception e) {
                if (e instanceof IllegalStateException) {
                    FocessQQ.getLogger().debugLang("plugin-depend-on-other-plugin", new Object[0]);
                }
                if (this.plugin != null) {
                    if (!(e instanceof PluginUnloadException)) {
                        FocessQQ.getLogger().thrLang("exception-load-plugin-file", e, new Object[0]);
                    } else {
                        FocessQQ.getLogger().debugLang("plugin-unload-self", this.plugin.getName());
                    }
                    ListenerHandler.unregister(this.plugin);
                    DataCollection.unregister(this.plugin);
                    Command.unregister(this.plugin);
                    Schedulers.close(this.plugin);
                    SimpleBotManager.remove(this.plugin);
                    CommandLine.unregister(this.plugin);
                    if (FocessQQ.getSocket() != null) {
                        FocessQQ.getSocket().unregister(this.plugin);
                    }
                    if (FocessQQ.getUdpSocket() != null) {
                        FocessQQ.getUdpSocket().unregister(this.plugin);
                    }
                } else if (e instanceof PluginLoadException) {
                    FocessQQ.getLogger().thrLang("exception-load-plugin-file", e, new Object[0]);
                }
                PluginCoreClassLoader.LOADERS.remove(this);
                return false;
            }
            FocessQQ.getLogger().debugLang("end-load-plugin", this.file.getName());
            return true;
        }
    }

    private void analyseClass(@NotNull Class<?> c) {
        for (Class<? extends Annotation> annotation : HANDLERS.keySet()) {
            Annotation a = c.getAnnotation(annotation);
            if (a == null) continue;
            HANDLERS.get(annotation).handle(c, a, this);
        }
        for (Field field : c.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            for (Class<? extends Annotation> annotation : FIELD_ANNOTATION_HANDLERS.keySet()) {
                Annotation a = field.getAnnotation(annotation);
                if (a == null) continue;
                field.setAccessible(true);
                FIELD_ANNOTATION_HANDLERS.get(annotation).handle(field, a, this);
            }
        }
    }

    public Class<?> findClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = null;
        for (Class<?> loadedClass : this.loadedClasses) {
            if (!loadedClass.getName().equals(name)) continue;
            c = loadedClass;
            break;
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            return this.jarFile.getInputStream(this.jarFile.getEntry(name));
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        LOCK = new Object();
        AFTER_PLUGINS_MAP = Maps.newHashMap();
        HANDLERS = Maps.newHashMap();
        FIELD_ANNOTATION_HANDLERS = Maps.newHashMap();
        RESOURCE_HANDLERS = Lists.newArrayList();
        PLUGIN_TYPE_HANDLER = (c, annotation, classLoader) -> {
            PluginType pluginType = (PluginType)annotation;
            if (pluginType.depend().length != 0) {
                boolean flag = false;
                for (String p : pluginType.depend()) {
                    if (Plugin.getPlugin(p) != null) continue;
                    AFTER_PLUGINS_MAP.compute(p, (key, value) -> {
                        if (value == null) {
                            value = Sets.newHashSet();
                        }
                        value.add(classLoader.file);
                        return value;
                    });
                    flag = true;
                }
                if (flag) {
                    throw new IllegalStateException("Plugin depends on other plugins, but not all of them are loaded.");
                }
            }
            if (Plugin.class.isAssignableFrom(c) && !Modifier.isAbstract(c.getModifiers())) {
                try {
                    Plugin plugin = (Plugin)c.newInstance();
                    if (!((PluginType)annotation).name().isEmpty()) {
                        String name = ((PluginType)annotation).name();
                        PLUGIN_NAME_FIELD.set(plugin, name);
                        PLUGIN_AUTHOR_FIELD.set(plugin, ((PluginType)annotation).author());
                        PLUGIN_VERSION_FIELD.set(plugin, new Version(((PluginType)annotation).version()));
                    }
                    PLUGIN_INIT_METHOD.invoke((Object)plugin, new Object[0]);
                    classLoader.plugin = plugin;
                    return true;
                }
                catch (Exception e) {
                    throw new PluginLoadException(c, e);
                }
            }
            throw new IllegalPluginClassException(c);
        };
        try {
            PLUGIN_NAME_FIELD = Plugin.class.getDeclaredField("name");
            PLUGIN_NAME_FIELD.setAccessible(true);
            PLUGIN_VERSION_FIELD = Plugin.class.getDeclaredField("version");
            PLUGIN_VERSION_FIELD.setAccessible(true);
            PLUGIN_AUTHOR_FIELD = Plugin.class.getDeclaredField("author");
            PLUGIN_AUTHOR_FIELD.setAccessible(true);
            COMMAND_NAME_FIELD = Command.class.getDeclaredField("name");
            COMMAND_NAME_FIELD.setAccessible(true);
            COMMAND_ALIASES_FIELD = Command.class.getDeclaredField("aliases");
            COMMAND_ALIASES_FIELD.setAccessible(true);
            COMMAND_INITIALIZE_FIELD = Command.class.getDeclaredField("initialize");
            COMMAND_INITIALIZE_FIELD.setAccessible(true);
            PLUGIN_INIT_METHOD = Plugin.class.getDeclaredMethod("init", new Class[0]);
            PLUGIN_INIT_METHOD.setAccessible(true);
        }
        catch (Exception e) {
            FocessQQ.getLogger().thrLang("exception-init-classloader", e, new Object[0]);
        }
        RESOURCE_HANDLERS.add((name, inputStream, pluginClassLoader) -> {
            if (name.endsWith(".class")) {
                try {
                    pluginClassLoader.loadedClasses.add(pluginClassLoader.loadClass(name.replace("/", ".").substring(0, name.length() - 6), true));
                }
                catch (ClassNotFoundException e) {
                    FocessQQ.getLogger().thrLang("exception-load-class", e, new Object[0]);
                }
            }
        });
        RESOURCE_HANDLERS.add((name, inputStream, pluginClassLoader) -> {
            if (name.equals("plugin.yml")) {
                pluginClassLoader.pluginDescription = new PluginDescription(YamlConfiguration.load(inputStream));
            }
        });
        HANDLERS.put(CommandType.class, (c, annotation, classLoader) -> {
            CommandType commandType = (CommandType)annotation;
            if (Command.class.isAssignableFrom(c) && !Modifier.isAbstract(c.getModifiers())) {
                try {
                    Plugin plugin = classLoader.plugin;
                    Command command = (Command)c.newInstance();
                    if (!commandType.name().isEmpty()) {
                        COMMAND_NAME_FIELD.set(command, commandType.name());
                        COMMAND_ALIASES_FIELD.set(command, Lists.newArrayList((Object[])commandType.aliases()));
                        if (!COMMAND_INITIALIZE_FIELD.getBoolean(command)) {
                            try {
                                command.init();
                            }
                            catch (Exception e) {
                                throw new CommandLoadException(c, e);
                            }
                            COMMAND_INITIALIZE_FIELD.set(command, true);
                        }
                    }
                    plugin.registerCommand(command);
                    return true;
                }
                catch (Exception e) {
                    if (e instanceof CommandDuplicateException) {
                        throw (CommandDuplicateException)e;
                    }
                    if (e instanceof CommandLoadException) {
                        throw (CommandLoadException)e;
                    }
                    throw new CommandLoadException(c, e);
                }
            }
            throw new IllegalCommandClassException(c);
        });
        HANDLERS.put(ListenerType.class, (c, annotation, classLoader) -> {
            if (Listener.class.isAssignableFrom(c) && !Modifier.isInterface(c.getModifiers()) && !Modifier.isAbstract(c.getModifiers())) {
                try {
                    Plugin plugin = classLoader.plugin;
                    Listener listener = (Listener)c.newInstance();
                    plugin.registerListener(listener);
                    return true;
                }
                catch (Exception e) {
                    throw new IllegalListenerClassException(c, e);
                }
            }
            throw new IllegalListenerClassException(c);
        });
        FIELD_ANNOTATION_HANDLERS.put(DataConverterType.class, (field, annotation, classLoader) -> {
            DataConverterType dataConverterType = (DataConverterType)annotation;
            if (DataConverter.class.isAssignableFrom(field.getType())) {
                try {
                    Plugin plugin = classLoader.plugin;
                    DataConverter dataConverter = (DataConverter)field.get(null);
                    Constructor<DataBuffer<?>> constructor = dataConverterType.buffer().getDeclaredConstructor(Integer.TYPE);
                    constructor.setAccessible(true);
                    plugin.registerBuffer(dataConverter, size -> {
                        try {
                            return (DataBuffer)constructor.newInstance(size);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                catch (Exception e) {
                    throw new IllegalDataConverterClassException(field.getType(), e);
                }
            } else {
                throw new IllegalDataConverterClassException(field.getType());
            }
        });
        FIELD_ANNOTATION_HANDLERS.put(SpecialArgumentType.class, (field, annotation, classLoader) -> {
            SpecialArgumentType specialArgumentType = (SpecialArgumentType)annotation;
            if (SpecialArgumentComplexHandler.class.isAssignableFrom(field.getType())) {
                try {
                    String name = specialArgumentType.name();
                    Plugin plugin = classLoader.plugin;
                    plugin.registerSpecialArgumentHandler(name, (SpecialArgumentComplexHandler)field.get(null));
                }
                catch (Exception e) {
                    throw new IllegalSpecialArgumentComplexHandlerClassException(field.getType(), e);
                }
            } else {
                throw new IllegalSpecialArgumentComplexHandlerClassException(field.getType());
            }
        });
        SCHEDULER = Schedulers.newThreadPoolScheduler(FocessQQ.getMainPlugin(), 2, false, "PluginLoader");
        GC_SCHEDULER = Schedulers.newFocessScheduler(FocessQQ.getMainPlugin(), "GC");
    }
}

